/*
 * afcrypto.cpp:
 *
 * command for dealing with encryption issues
 */

/*
 * Copyright (c) 2007
 *	Simson L. Garfinkel and Basis Technology, Inc. 
 *      All rights reserved.
 *
 * This code is derrived from software contributed by
 * Simson L. Garfinkel
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by Simson L. Garfinkel
 *    and Basis Technology Corp.
 * 4. Neither the name of Simson Garfinkel, Basis Technology, or other
 *    contributors to this program may be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY SIMSON GARFINKEL, BASIS TECHNOLOGY,
 * AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL SIMSON GARFINKEL, BAIS TECHNOLOGy,
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.  
 */

#include "config.h"
#include "afflib.h"
#include "afflib_i.h"

#include <stdio.h>
#include <algorithm>
#include <vector>

char *progname = "afcrypto";
int opt_change = 0;

void usage()
{
    printf("afcrypto version %s\n",PACKAGE_VERSION);
    printf("usage: afcrypto [options] filename.aff\n");
    printf("options:\n");
    printf("    -c      --- change passphrase\n");
    printf("    -v      --- Just print the version number and exit.\n");
    exit(0);
}

void process(const char *fn)
{
    char old_passphrase[1024];
    char new_passphrase[1024];

    memset(old_passphrase,0,sizeof(old_passphrase));
    memset(new_passphrase,0,sizeof(new_passphrase));

    printf("Enter old passphrase: ");
    fgets(old_passphrase,sizeof(old_passphrase),stdin);
    char *cc = strchr(old_passphrase,'\n');if(cc) *cc='\000';

    /* See if this passphrase works*/

    AFFILE *af = af_open(fn,O_RDONLY,0666);
    if(!af) err(1,fn);
    if(af_use_aes_passphrase(af,old_passphrase)){
	err(1,"af_use_aes_passphrase failed");
    }
    af_close(af);

    printf("Enter new passphrase: ");
    fgets(new_passphrase,sizeof(new_passphrase),stdin);
    cc = strchr(new_passphrase,'\n');if(cc) *cc='\000';

    af = af_open(fn,O_RDWR,0666);
    if(!af) err(1,fn);
    if(af_change_aes_passphrase(af,old_passphrase,new_passphrase)){
	err(1,"af_change_aes_passphrase failed");
    }
    af_close(af);
    printf("passphrase successfully changed.\n");
}

int main(int argc,char **argv)
{
    int bflag, ch;

    bflag = 0;
    while ((ch = getopt(argc, argv, "ch?v")) != -1) {
	switch (ch) {
	case 'c': opt_change = 1; break;
	case 'h':
	case '?':
	default:
	    usage();
	    break;
	case 'v':
	    printf("%s version %s\n",progname,PACKAGE_VERSION);
	    exit(0);
	}
    }
    argc -= optind;
    argv += optind;

    if(argc!=1){
	usage();
    }

    process(argv[0]);
}
