# Script for compiling libewf
# as part of The Sleuth Kit
#
# $Date: 2007/09/06 20:47:21 $
#
cd libewf
if (test -f './Makefile') then
    true
else
    (touch Makefile.am && \
     touch libewf/Makefile.am && \
     touch ewftools/Makefile.am && \
     touch configure.ac && \
     touch configure.in && \
     touch aclocal.m4 && \
     touch Makefile.in && \
     touch libewf/Makefile.in && \
     touch config.h.in && \
     touch libewf/libewf_config.h.in && \
     touch include/libewf.h.in && \
     touch include/libewf/libewf_definitions.h.in && \
     touch include/libewf/libewf_types.h.in && \
     touch configure) || (cd ..; exit $?)
    ./configure --enable-shared=no || (cd ..; exit $?)
fi

make library

if (test -f 'libewf/.libs/libewf.a') then 
    mkdir libewf-tsk
    if (test -d 'libewf-tsk') then
	cp libewf/.libs/libewf.a libewf-tsk
	(cd libewf-tsk; ar x libewf.a; cd ..)
	ar rv ../../lib/libtsk.a libewf-tsk/*.o
	rm -rf libewf-tsk
    else
	echo "Error creating tmp directory in libewf"
	cd ..
	exit 1
    fi
else
    echo "Error: Missing libewf/.libs/libewf.a file"
    cd ..
    exit 1
fi

cd ..
