/*
** get
** The @stake Sleuth Kit (TASK)
**
** routines to get values in a structure that solves endian issues
**
** Brian Carrier [carrier@atstake.com]
** Copyright (c) 2002 Brian Carrier, @stake Inc.  All rights reserved
**
*/

#include "fs_tools.h"
#include "error.h"


#if 0
u_int16_t
getu16(FS_INFO *fs, u_int8_t *x)
{
	return ((fs->flags & FS_LIT_ENDIAN) ? 
	  (x[0] + (x[1] << 8)) : 
	  (x[1] + (x[0] << 8)) );
}



/*
 * return a u32 value based on the fs->flags value for ordering
 */
u_int32_t
getu32(FS_INFO *fs, u_int8_t *x)
{
	return ( (fs->flags & FS_LIT_ENDIAN)  ? 
	  (x[0] + (x[1] << 8) + (x[2] << 16) + (x[3] << 24) ) : 
	  (x[3] + (x[2] << 8) + (x[1] << 16) + (x[0] << 24) ) );
}

u_int64_t
getu48(FS_INFO *fs, u_int8_t *x)
{
	return ( (fs->flags & FS_LIT_ENDIAN) ?

	  (u_int64_t)((x[0] + (x[1] << 8) + (x[2] << 16) + (x[3] << 24)) +
		  (u_int64_t)((u_int64_t)x[4] << 32) + 
		  (u_int64_t)((u_int64_t)x[5] << 40)) :

	  (u_int64_t)((x[5] + (x[4] << 8) + (x[3] << 16) + (x[2] << 24)) +
		  (u_int64_t)((u_int64_t)x[1] << 32) + 
		  (u_int64_t)((u_int64_t)x[0] << 40)) );
}


u_int64_t
getu64(FS_INFO *fs, u_int8_t *x)
{
	return ( (fs->flags & FS_LIT_ENDIAN) ?
	  (u_int64_t)((x[0] + (x[1] << 8) + (x[2] << 16) + (x[3] << 24)) +
		  (u_int64_t)((u_int64_t)x[4] << 32) + 
		  (u_int64_t)((u_int64_t)x[5] << 40) +
		  (u_int64_t)((u_int64_t)x[6] << 48) + 
		  (u_int64_t)((u_int64_t)x[7] << 56)) :
	  (u_int64_t)((x[7] + (x[6] << 8) + (x[5] << 16) + (x[4] << 24)) +
		  (u_int64_t)((u_int64_t)x[3] << 32) + 
		  (u_int64_t)((u_int64_t)x[2] << 40) +
		  (u_int64_t)((u_int64_t)x[1] << 48) + 
		  (u_int64_t)((u_int64_t)x[0] << 56)) );
}

#endif

/*
 * try both endian orderings to figure out which one is equal to 'val'
 *
 * if neither of them do, then 1 is returned.  Else 0 is.
 * fs->flags will be set accordingly
 */
u_int8_t
guessu16(FS_INFO *fs, u_int8_t *x, u_int16_t val)
{
	/* try little */
	fs->flags &= ~FS_BIG_ENDIAN;
	fs->flags |= FS_LIT_ENDIAN;
	if (getu16(fs, x) == val)
		return 0;

	/* ok, big now */
	fs->flags &= ~FS_LIT_ENDIAN;
	fs->flags |= FS_BIG_ENDIAN;
	if (getu16(fs, x) == val)
		return 0;

	/* didn't find it */
	return 1;
}

/*
 * same idea as guessu16 except that val is a 32-bit value
 *
 * return 1 on error and 0 else
 */
u_int8_t
guessu32(FS_INFO *fs, u_int8_t *x, u_int32_t val)
{
	/* try little */
	fs->flags &= ~FS_BIG_ENDIAN;
	fs->flags |= FS_LIT_ENDIAN;
	if (getu32(fs, x) == val)
		return 0;

	/* ok, big now */
	fs->flags &= ~FS_LIT_ENDIAN;
	fs->flags |= FS_BIG_ENDIAN;
	if (getu32(fs, x) == val)
		return 0;

	return 1;
}
