/*
** fs_dent.h
** TCTUTILs Package
**
** Generic header file for fs_dent functions
**
** Brian Carrier [carrier@cerias.purdue.edu]
**
**  $Revision: 0.4 $
**
*/
#ifndef _FS_DENT_H
#define _FS_DENT_H

#if defined(HAVE_UFS_FFS)
#define FS_DENT_FFS	0x1
#endif

#if defined(HAVE_EXT2FS)
#define FS_DENT_EXT2	0x2
#endif

/* Type of file that entry is for */
#define FS_DENT_UNDEF 	0	/* Unknown Type */
#define FS_DENT_FIFO 	1	/* named pipe */
#define FS_DENT_CHR	 	2	/* character */
#define FS_DENT_DIR 		4	/* directory */
#define FS_DENT_BLK	 	6	/* block */
#define FS_DENT_REG	 	8	/* regular file */
#define FS_DENT_LNK		10	/* symbolic link */
#define FS_DENT_SOCK		12	/* socket */

#if defined(SUNOS5)
#define FS_DENT_SHAD		13	/* shadow inode (solaris) */
#endif

#if defined(OPENBSD2)
#define FS_DENT_WHT		14	/* whiteout (openbsd) */
#endif

#define FS_DENT_MASK		15	/* mask value */
#define FS_DENT_MAX_STR	15	/* max index for string version of types */

/* ascii representation of above types */
extern char fs_dent_str[FS_DENT_MAX_STR][2];

typedef struct FS_DENT {
	unsigned int inode;		/* inode number */
	unsigned int nextLink;	/* distance until next entry 
							** this is typical the reclen value in the
							** original structure */
	unsigned int reclen;	/* actual length of record 
							** this is determined using a builtin
							** macro */
	unsigned char fs_type; 	/* ffs or ext2fs */
	unsigned char ent_type; /* dir, file etc */
	unsigned char namlen;	/* length of actual name */
	unsigned char maxnamlen;/* size allocated */
	char *name;				/* name of file, directory etc 
							** this MUST be NULL terminated */
	struct FS_INODE *fsi;	/* Inode structure */
} FS_DENT;

typedef void (*FS_DENT_WALK_FN) (FS_DENT *, int, char *);

extern FS_DENT *fs_dent_alloc(char);
extern void fs_dent_realloc(FS_DENT *, char);
extern void fs_dent_free(FS_DENT *);
extern void fs_dent_print(FILE *, FS_DENT *, FS_INFO *, char *, signed int);
extern void fs_dent_print_mac(FILE *, FS_DENT *, FS_INFO *, char *, 
  signed int, unsigned char );
extern void fs_dent_walk(FS_INFO *, INUM_T, int, 
  FS_DENT_WALK_FN, FS_DENT_WALK_FN, char *, char ); 

/*
** Is this string a "." or ".."
*/
#define ISDOT(str) (((str[0] == '.') && ((str[1] == '.') || \
 (str[1] == '\0'))) ? 1 : 0 )

#endif

