#include	<config.h>
#include	"cdb.h"
#include	"buffer.h"
#include	"cdb_make.h"
#include	"uint32.h"

int cdb_put(struct cdb_make *c,
	    char *key, unsigned klen, void *val, unsigned vlen)
{
    int			i;
    uint32		h;

    if (cdb_make_addbegin(c, klen, vlen) == -1)
      return -1;
    buffer_put(&c->b, key, klen);
    for (i = 0, h = CDB_HASHSTART; i < klen; ++i)
      h	 = cdb_hashadd(h, key[i]);
    buffer_put(&c->b, val, vlen);
    if (cdb_make_addend(c, klen, vlen, h) == -1)
      return -1;

    return 0;
}

