#include	<config.h>
#include	<stdlib.h>
#include	<unistd.h>
#include	<errno.h>
#include	"cdb.h"
#include	"buffer.h"
#include	"cdb_make.h"
#include	"uint32.h"
#include	"elcerror.h"
#include	"cdb_seq.h"

#define	CDB_HEADER_SIZE	(2048)

int cdb_seq_start(cdb_seq *c)
{
    int		err;
    int		fd	 = c->fd;

    if ( (err = lseek(fd, 0, SEEK_SET)) == -1)
      return -1;
    if ( (err = read(fd, &c->eod, sizeof(c->eod))) == -1)
      return -1;
    else if (err < sizeof(c->eod)) {
      errno	 = ENODATA;
      return -1;
    }

    return lseek(fd, CDB_HEADER_SIZE, SEEK_SET);
}

int cdb_seq_eod(cdb_seq *c)
{
    int		pos;

    if ( (pos = lseek(c->fd, 0, SEEK_CUR)) == -1)
      return -1;

    return pos >= c->eod;
}

int cdb_seq_sizes(cdb_seq *c, size_t *klen, size_t *vlen)
{
    int		err;

    if ( (err = read(c->fd, klen, sizeof(*klen))) == -1)
      return -1;
    else if (err == 0)
      return 1;			/* no more */

    if ( (err = read(c->fd, vlen, sizeof(*vlen))) == -1)
      return -1;
    else if (err == 0)
      return 1;			/* no more */

    return 0;
}

int cdb_seq_get(cdb_seq *c, void *key, size_t klen, void *data, size_t dlen)
{
    int		err;

    if ( (err = read(c->fd, key, klen)) == -1)
      return -1;
    else if (err == 0)
      return 1;			/* no more */

    if ( (err = read(c->fd, data, dlen)) == -1)
      return -1;
    else if (err == 0)
      return 1;			/* no more */

    return 0;
}

int cdb_seq_getkey(cdb_seq *c, void *key, size_t klen, size_t dlen)
{
    int		err;

    if ( (err = read(c->fd, key, klen)) == -1)
      return -1;
    else if (err == 0)
      return 1;			/* no more */

    if (lseek(c->fd, dlen, SEEK_CUR) == -1)
      return -1;

    return 0;
}

