#include	<config.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<errno.h>
#include	"checkset.h"
#include	"elcerror.h"
#include	"elcerror_p.h"
#include	"checkset_p.h"
#ifdef		ELC_FIND_LEAKS
#include	"leakfind.h"
#endif

void checkset_show(FILE *out, checkset c)
{
    int		i;

    if (CHECKSET_GETIGNORE(c))
      fputc('!', out);
    if (CHECKSET_GETNOCHILD(c))
      fputc('=', out);

    for (i = 0; i < CHECKSET_LEN(c); ++i)
      fputc(CHECKSET_GET(c, i), out);
}

checkset checkset_new(size_t n)
{
    checkset	c	 = malloc(sizeof(*c) * (n+2));
    if (! c)
      DIE("malloc new checkset");
    c[0]	 = n;		/* first byte is number of switches */
    c[1]	 = 0;		/* second byte is for non-inheriting flags */
    return c;
}

void checkset_free(checkset c)
{
    free(c);
}
