#include	<config.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<stdarg.h>
#include	"elcerror.h"
#include	"elcerror_p.h"
#ifdef		ELC_FIND_LEAKS
#include	"leakfind.h"
#endif

#ifndef	PROGNAME
#error define PROGNAME before compiling, e.g.,
#error gcc -Wall -DPROGNAME='"foobar"' -c elcerror.c
#endif

void die(char *function, char *fmt, ...)
{
    va_list	args;

    fprintf(stderr, "%s (%s): ", PROGNAME, function);
    va_start(args, fmt);
    vfprintf(stderr, fmt, args);
    fputc('\n', stderr);
    va_end(args);
    exit(EXIT_FAILURE);
}

void warn(char *function, char *fmt, ...)
{
    va_list	args;

    fprintf(stderr, "%s (%s): ", PROGNAME, function);
    va_start(args, fmt);
    vfprintf(stderr, fmt, args);
    fputc('\n', stderr);
    va_end(args);
}
