#include	<config.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<ctype.h>
#include	<values.h>	/* for CHARBITS */
#include	"hashtbl/hashtbl.h"
#include	"hashtbl/xstrdup.h"
#include	"cdb.h"
#include	"cdb_make.h"
#include	"options.h"
#include	"elcerror.h"
#include	"rules.h"
#include	"checkset.h"
#include	"elcerror_p.h"
#include	"rules_p.h"
#ifdef		ELC_FIND_LEAKS
#include	"leakfind.h"
#endif

inline static void binprint(void *data, size_t n)
{
    char	*d	 = (char *) data;
    char	c;
    int		i;

    while (n--) {
      c	 = d[n];
      for (i = CHARBITS; i; --i)
	putchar((c >> (i - 1) & 1) ? '1' : '0');
    }
}

unsigned char2rulebit(unsigned char c)
{
    /* SsIiPpLlUuGgZzAaMmCc */
    switch (c) {
      case 's':
      case 'S':
	return	RULE_SUM;	break;
      case 'I':
      case 'i':
	return	RULE_INODE;	break;
      case 'p':
      case 'P':
	return	RULE_PERMS;	break;
      case 'L':
      case 'l':
	return	RULE_NLINK;	break;
      case 'U':
      case 'u':
	return	RULE_UID;	break;
      case 'G':
      case 'g':
	return	RULE_GID;	break;
      case 'Z':
      case 'z':
	return	RULE_SIZE;	break;
      case 'A':
      case 'a':
	return	RULE_ATIME;	break;
      case 'M':
      case 'm':
	return	RULE_MTIME;	break;
#if 0
      case 'C':
      case 'c':
	return	RULE_CTIME;	break;
#endif
      default:
	abort();		/* shouldn't happen.  dump core */
	break;
    };
}

static void rule_override(unsigned long *flags, checkset rules)
{
    int			n_switches;
#if 0				/* debug */
    int			oldflags	 = *flags;
#endif
    int			i;
    unsigned char	s;

    if (CHECKSET_GETIGNORE(rules)) {
      *flags	 |= RULE_IGNORE;
      return;			/* nothing else matters */
    }
    if (CHECKSET_GETNOCHILD(rules))
      *flags	 |= RULE_NOCHILDREN;

    n_switches	 = CHECKSET_LEN(rules);
    for (i = 0; i < n_switches; ++i) {
      s	 = CHECKSET_GET(rules, i);
#if 0				/* debug */
      fputs(" -", stdout);
      putchar(s);
      putchar('-');
#endif
      if (isupper(s))
	*flags	 &= ~char2rulebit(s); /* turn off */
      else
	*flags	 |= char2rulebit(s); /* turn on */
    }

#if 0				/* debug */
    if (CHECKSET_LEN(rules)) {
      fputs(" override ", stdout);
      binprint(&oldflags, sizeof(oldflags));
      fputs(" with new ", stdout);
      binprint(flags, sizeof(*flags));
      putchar('\n');
    }
#endif
}

unsigned long rules_for_path(options *opts, const char *path_orig)
{
    char	*path	 = xstrdup(path_orig);
    char	*p	 = path; /* pointer for running along path */
    char	tmp;
    char	*root	 = opts->root;
    checkset	thisrule;	/* for each level of the path */
    hashtbl_t		*rules	 = opts->ruleset;
    unsigned long	flags	 = opts->default_flags;
#if 0				/* debug */
    static int	counter;

    printf("rules_for_path #%d\n", ++counter);
#endif

    if (strstr(path, root) != path)
      die(__FUNCTION__, "Error: root not found in path (%s)", path);
    p	 += strlen(root);

    for (;;) {
      tmp	 = *p;
      *p	 = '\0';
#if 0				/* debug */
      puts(path);
#endif
      if ( (thisrule = hashtbl_lookup(rules, path, strlen(path))) ) {
#if 0
	fputs(path, stdout);	/* debug */
#endif
	rule_override(&flags, thisrule); /* override *r with *thisrule */
      }
      if (! (*p++ = tmp) )	/* reset the separator */
	break;
      while (*p && (*p != '/'))	/* find the next slash */
	++p;
    }

    free(path);
    return flags;
}

