/*
hashtbl
Copyright (C) 2000 Ed Cashin

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifndef	ELC_HASH_H
#define	ELC_HASH_H

#include	<stdlib.h>
#include	<stdint.h>

typedef struct elc_hashnode_struct {
  struct elc_hashnode_struct	*next;
  char				*key;
  size_t			keylen;
  void				*data;
} hashnode_t;

typedef struct elc_hashtbl_struct {
  hashnode_t	**tbl;
  int		entries;
  size_t	capacity;
} hashtbl_t;

/* use zero capacity for hashtbl's default capacity */
void hashtbl_init(hashtbl_t *h, size_t capacity);
void hashtbl_destroy(hashtbl_t *h);
void hashtbl_free(hashtbl_t *h);
void *hashtbl_store(hashtbl_t *h, const char *key, size_t keylen, void *data);
void *hashtbl_remove(hashtbl_t *h, const char *key, size_t keylen);
void *hashtbl_lookup(hashtbl_t *h, const char *key, size_t keylen);

#endif
