/*
integrit - file integrity verification system
Copyright (C) 2000 Ed Cashin

You can redistribute this program and/or modify it under the terms of
the Artistic License as published by the Open Source Initiative,
currently at the following URL:

    http://www.opensource.org/licenses/artistic-license.html

THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

*/
#include	<config.h>
#include	<stdio.h>
#include	<time.h>
#include	"cdb.h"
#include	"cdb_make.h"
#include	"hashtbl/hashtbl.h"
#include	"options.h"
#ifdef		ELC_FIND_LEAKS
#include	"leakfind.h"
#endif

#define	XML_VERSION	"1.0"

void xml_declaration(FILE *out)
{
    fputs("<? xml version=\"" XML_VERSION "\"?>\n", out);
}

void xml_putc(FILE *out, int ch)
{
    switch (ch) {
      case '<':
	fputs("&lt;", out);
	break;
      case '>':
	fputs("&gt;", out);
	break;
      case '&':
	fputs("&amp;", out);
	break;
      default:
	putc(ch, out);
	break;
    }
}

void xml_start_print(FILE *out, const char *tag)
{
    fprintf(out, "<%s>", tag);
}

void xml_end_print(FILE *out, const char *tag)
{
    fprintf(out, "</%s>", tag);
}

void xml_print(FILE *out, const char *buf)
{
    for (; *buf; ++buf)
      xml_putc(out, *buf);
}

void xml_start_report(FILE *out, const options *o)
{
    fprintf(out, "<report date=\"%ld\" integrit_version=\"%s\">\n",
	    time(NULL), INTEGRIT_VERSION);
}

