/*
integrit - file integrity verification system
Copyright (C) 2000 Ed Cashin

You can redistribute this program and/or modify it under the terms of
the Artistic License as published by the Open Source Initiative,
currently at the following URL:

    http://www.opensource.org/licenses/artistic-license.html

THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

*/
#include	<config.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<stdarg.h>
#include	<errno.h>
#ifdef	ELC_FIND_LEAKS
#include	"leakfind.h"
#endif

#ifndef	PROGNAME
#define	PROGNAME	"test"
#endif
#ifndef	fatal_error
#define	fatal_error(s)	do {					\
    fprintf(stderr, PROGNAME ": Error in %s (%s): %s\n",	\
	    __FUNCTION__, s, strerror(errno));			\
    exit(EXIT_FAILURE);						\
} while (0)
#endif

char *xstradd(const char *str1, ...)
{
    va_list	ap;		/* arg pointer */
    char	*str;
    char	*newstr;
    int		totalchars	 = 1;

    totalchars	 += strlen(str1);

    va_start(ap, str1);
    while ( (str = va_arg(ap, char *)) )
      totalchars         += strlen(str);

    newstr	 = malloc(sizeof(char) * totalchars);
    if (! newstr)
      fatal_error("malloc new string");

    strcpy(newstr, str1);
    
    va_start(ap, str1);
    while ( (str = va_arg(ap, char *)) )
      strcat(newstr, str);

    va_end(ap);
#if defined	ELC_FIND_LEAKS && 0
    fprintf(stderr, "alloc %d (%s) in %s\n",
	    strlen(newstr), newstr, __FUNCTION__);
#endif
    return newstr;
}
