/*
integrit - file integrity verification system
Copyright (C) 2000 Ed Cashin

You can redistribute this program and/or modify it under the terms of
the Artistic License as published by the Open Source Initiative,
currently at the following URL:

    http://www.opensource.org/licenses/artistic-license.html

THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

*/
#ifndef	ELC_XML_H
#define	ELC_XML_H

#define	XML_START(tag)	("<" tag ">")
#define	XML_END(tag)	("</" tag ">")
#define	XML_START_PRINT(out, tag)	(fprintf(out, XML_START(tag)))
#define	XML_END_PRINT(out, tag)	(fprintf(out, XML_END(tag)))
#define	XML_ELEMENT_PRINT(out, tag, content) do {	\
    fputs("<" tag ">", (out));				\
    xml_print((out), (content));			\
    fputs("</" tag ">\n", (out));			\
} while (0);
#define	XML_CHANGE_START_PRINT(out, type, path) do {	\
    fprintf(out, "<change type=\"%s\" file=\"", type);	\
    xml_print(out, path);				\
    fprintf(out, "\">");				\
} while (0)

#endif
