/*
integrit - file integrity verification system
Copyright (C) 2000 Ed Cashin

You can redistribute this program and/or modify it under the terms of
the Artistic License as published by the Open Source Initiative,
currently at the following URL:

    http://www.opensource.org/licenses/artistic-license.html

THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

*/
#include	<config.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<stdarg.h>
#include	"elcerror.h"
#include	"elcerror_p.h"
#ifdef		ELC_FIND_LEAKS
#include	"leakfind.h"
#endif

#ifndef	PROGNAME
#error define PROGNAME before compiling, e.g.,
#error gcc -Wall -DPROGNAME='"foobar"' -c elcerror.c
#endif

void die(char *function, char *fmt, ...)
{
    va_list	args;

    fprintf(stderr, "%s (%s): ", PROGNAME, function);
    va_start(args, fmt);
    vfprintf(stderr, fmt, args);
    fputc('\n', stderr);
    va_end(args);
    exit(EXIT_FAILURE);
}

void warn(char *function, char *fmt, ...)
{
    va_list	args;

    fprintf(stderr, "%s (%s): ", PROGNAME, function);
    va_start(args, fmt);
    vfprintf(stderr, fmt, args);
    fputc('\n', stderr);
    va_end(args);
}
