/*
integrit - file integrity verification system
Copyright (C) 2000 Ed Cashin

You can redistribute this program and/or modify it under the terms of
the Artistic License as published by the Open Source Initiative,
currently at the following URL:

    http://www.opensource.org/licenses/artistic-license.html

THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

*/
#ifndef	INT_OPTIONS_H
#define	INT_OPTIONS_H

enum integrit_output {
  OUTPUT_LINES,			/* human-readable lines output */
  OUTPUT_XML,			/* XML output */
};  

typedef struct options {
  char			*conffile;	/* from argv, so don't free */
  char			*knowndbname;
  struct cdb		knowndb;
  char			*currdbname;
  struct cdb_make	currdb;
  char			*root;
  hashtbl_t		*ruleset;
  int			verbose;
  unsigned long		default_flags;
  enum integrit_output	output;	/* type of output */
  unsigned		do_check: 1;	/* test files against known-state db */
  unsigned		do_update: 1;	/* generate current-state db */
} options;

#endif
