#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>
#include	<unistd.h>
#include	<fcntl.h>
#include	<limits.h>
#include	<errno.h>
#include	<sys/stat.h>
#include	<openssl/sha.h>
#include	"utilities_p.h"
#include	"elcerror_p.h"
#include	"elcerror.h"
#include	"cdb_seq.h"
#include	"dbinfo.h"
#include	"cdb.h"

typedef struct options {
  char		*targetname;
  unsigned	checksums: 1;
} options;  

/* based on show_diff_lines_long in eachfile.c */
static void show_long(FILE *out, char T, long val)
{
    fprintf(out, "%c(%ld) ", T, val);
}
static void show_octal(FILE *out, char T, unsigned long val)
{
    fprintf(out, "%c(%lo) ", T, val);
}
/* based on show_diff_lines_time from eachfile.c */
static void show_time(FILE *out, char T, time_t val)
{
    const int	buf_max	 = 16;	/* 20001212-010101 + null */
    char	buf[buf_max];

    putc(T, out);
    putc('(', out);

    if (! strftime(buf, buf_max, "%Y%m%d-%H%M%S", localtime(&val)) )
      DIE("strftime");
    fputs(buf, out);

    fputs(") ", out);
}
void show_checksum(FILE *out, char *sum, size_t siz)
{
    fputs("s(", out);
    hexprint(out, sum, siz);
    fputs(") ", out);
}

void show_entry(options *opts,
		const char *key, size_t klen, dbinfo *val, size_t vlen)
{
    int			i;
    const unsigned	perm_mask	 = 07777;

    /* show the filename */
    for (i = 0; i < klen; ++i)
      putc(key[i], stdout);
    fputs("   ", stdout);
    show_long(stdout, 'i', val->stat.st_ino);
    show_octal(stdout, 'p', val->stat.st_mode & perm_mask);
    show_long(stdout, 'l', val->stat.st_nlink);
    show_long(stdout, 'u', val->stat.st_uid);
    show_long(stdout, 'g', val->stat.st_gid);
    show_long(stdout, 'z', val->stat.st_size);
    show_time(stdout, 'a', val->stat.st_atime);
    show_time(stdout, 'm', val->stat.st_mtime);
    show_time(stdout, 'c', val->stat.st_ctime);
    if (opts->checksums && (vlen == sizeof(dbinfo)))
      show_checksum(stdout, val->sum, sizeof(val->sum));
    putc('\n', stdout);
}

void viewdb(options *opts)
{
    cdb_seq	seq;
    int		err;
    unsigned	ksiz	 = 1024; /* beginning key space allotment */
    char	*key	 = malloc(ksiz);
    dbinfo	val;
    size_t	klen, vlen;

    if (! key)
      DIE("malloc key");

    if ( (seq.fd = open(opts->targetname, O_RDONLY | O_NDELAY)) == -1)
      die(__FUNCTION__, "Error: opening integrit database (%s): %s",
	  opts->targetname, strerror(errno));
      
    if (cdb_seq_start(&seq) == -1)
      DIE("cdb_seq_start");
    while (! cdb_seq_eod(&seq)) { /* while not end of data */
      if ( (err = cdb_seq_sizes(&seq, &klen, &vlen)) == -1)
	DIE("cdb_seq_sizes");
      else if (err == 1)	/* no more in db sequence */
	break;
      while (klen > ksiz) {
	if (ksiz > (UINT_MAX / 2))
	  DIE("key size too big");
	ksiz	 *= 2;
	if (! (key = realloc(key, ksiz)) )
	  DIE("realloc key");
      }
      if (vlen > sizeof(val))
	die(__FUNCTION__, "Error: bad entry (too big value) in DB (%s)\n",
	    opts->targetname);
      if (cdb_seq_get(&seq, key, klen, &val, vlen) == -1)
	DIE("cdb_seq_getkey");
      show_entry(opts, key, klen, &val, vlen);
    }

    free(key);
}

void usage(void)
{
    fputs("usage:\n    i-viewdb [-s] {dbfile}\n"
	  "options:\n    -s    show checksums\n",
	  stderr);
}

int main(int argc, char *argv[])
{
    options	opts	 = { NULL, 0 };
    char	*arg	 = argv[1];

    if (argc > 2)
      /* handle the checksums option */
      if (! strcmp(arg, "-s")) {
	opts.checksums	 = 1;
	arg	 = argv[2];
      }
    if (argc > 1)
      opts.targetname	 = arg;
    
    if (opts.targetname) {
      viewdb(&opts);
    } else {
      usage();
      exit(EXIT_FAILURE);
    }
    
    return 0;
}
