/*
integrit - file integrity verification system
Copyright (C) 2000 Ed Cashin

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include	<config.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<limits.h>
#include	<errno.h>
#include	"checkset.h"
#include	"elcerror.h"
#include	"elcerror_p.h"
#include	"checkset_p.h"
#ifdef		ELC_FIND_LEAKS
#include	"leakfind.h"
#endif

void checkset_init(checkset c, size_t n)
{
    if (n > CHECKSET_MAXLEN)
      DIE("too many members for checkset");
    c[0]	 = n;
    c[1]	 = 0;
}

void checkset_show(FILE *out, checkset c)
{
    int		i;

    if (CHECKSET_GETIGNORE(c))
      putc('!', out);
    if (CHECKSET_GETNOCHILD(c))
      putc('=', out);

    for (i = 0; i < CHECKSET_LEN(c); ++i)
      putc(CHECKSET_SWITCH_AT(c, i), out);
}

checkset checkset_new(size_t n)
{
    checkset	c	 = malloc(sizeof(*c) * (n+2));
    if (! c)
      DIE("malloc new checkset");
    c[0]	 = n;		/* first byte is number of switches */
    c[1]	 = 0;		/* second byte is for non-inheriting flags */
    return c;
}

void checkset_free(checkset c)
{
    free(c);
}
