/*
integrit - file integrity verification system
Copyright (C) 2001 Ed Cashin

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>
#include	<time.h>
#include	<errno.h>
#include	<sys/stat.h>
#include	<openssl/sha.h>
#include	"utilities_p.h"
#include	"elcerror_p.h"
#include	"elcerror.h"
#include	"dbinfo.h"
#include	"show.h"

/* based on show_diff_lines_long in eachfile.c */
static void show_long(FILE *out, char T, long val)
{
    fprintf(out, "%c(%ld) ", T, val);
}
static void show_octal(FILE *out, char T, unsigned long val)
{
    fprintf(out, "%c(%lo) ", T, val);
}
/* based on show_diff_lines_time from eachfile.c */
static void show_time(FILE *out, char T, time_t val)
{
    const int	buf_max	 = 16;	/* 20001212-010101 + null */
    char	buf[buf_max];

    putc(T, out);
    putc('(', out);

    if (! strftime(buf, buf_max, "%Y%m%d-%H%M%S", localtime(&val)) )
      DIE("strftime");
    fputs(buf, out);

    fputs(") ", out);
}
static void show_checksum(FILE *out, char *sum, size_t siz)
{
    fputs("s(", out);
    hexprint(out, sum, siz);
    fputs(") ", out);
}

void show_entry(int show_checksums,
		const char *key, size_t klen, dbinfo *val, size_t vlen)
{
    int			i;
    const unsigned	perm_mask	 = 07777;

    /* show the filename */
    for (i = 0; i < klen; ++i)
      putc(key[i], stdout);
    fputs("   ", stdout);
    show_long(stdout, 'i', val->stat.st_ino);
    show_octal(stdout, 'p', val->stat.st_mode & perm_mask);
    show_long(stdout, 'l', val->stat.st_nlink);
    show_long(stdout, 'u', val->stat.st_uid);
    show_long(stdout, 'g', val->stat.st_gid);
    show_long(stdout, 'z', val->stat.st_size);
    show_time(stdout, 'a', val->stat.st_atime);
    show_time(stdout, 'm', val->stat.st_mtime);
    show_time(stdout, 'c', val->stat.st_ctime);
    if (show_checksums && (vlen == sizeof(dbinfo)))
      show_checksum(stdout, val->sum, sizeof(val->sum));
    putc('\n', stdout);
}

