/*
integrit - file integrity verification system
Copyright (C) 2001 Ed Cashin

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
/* pack and unpack numbers from unsigned 32-bit native-format integers
 * into little-endian 32-bit representation for storage in CDB-format
 * database.
 */
#include	<config.h>
/* support platforms that don't yet conform to C99 */
#if	HAVE_STDINT_H
#include	<stdint.h>
#elif	HAVE_INTTYPES_H
#include	<inttypes.h>
#else
#error No stdint.h or inttypes.h found.
#endif
#include	"packint.h"

/* these routines are currently unused */

void uint32_unpack(const uint8_t in[4], uint32_t *n)
{
    /* input format is little-endian */
    uint32_t	buf;
#ifdef	BIG_ENDIAN_HOST	/* swap */
    buf	 = (uint8_t) in[3];	/* most-sig byte ends up on left */
    buf	 <<= 8;
    buf	 += (uint8_t) in[2];
    buf	 <<= 8;
    buf	 += (uint8_t) in[1];
    buf	 <<= 8;
    buf	 += (uint8_t) in[0];
#else
    buf	 = (uint8_t) in[0];	/* least-sig byte ends up on left */
    buf	 <<= 8;
    buf	 += (uint8_t) in[1];
    buf	 <<= 8;
    buf	 += (uint8_t) in[2];
    buf	 <<= 8;
    buf	 += (uint8_t) in[3];
#endif
    *n	 = buf;
}

void uint32_pack(uint8_t out[4], uint32_t n)
{
    /* output format is little-endian */
#if 1				/* always little-endian (backwards) output */
    out[0]	 = n & 0xff;	/* put low-order byte on left */
    n		 >>= 8;
    out[1]	 = n & 0xff;
    n		 >>= 8;
    out[2]	 = n & 0xff;
    n		 >>= 8;
    out[3]	 = n;
#else
    out[3]	 = n & 0xff;	/* put low-order byte on right */
    n		 >>= 8;
    out[2]	 = n & 0xff;
    n		 >>= 8;
    out[1]	 = n & 0xff;
    n		 >>= 8;
    out[0]	 = n;
#endif
}
