/*
 * This file is part of Distributed John,
 * Copyright (C) 2001-2003 by Luis Parravicini
 * http://ktulu.com.ar
 */
#include "defs.h"

/*
 * Return the size of the packet according to the action to be performed
 * or -1 on an unknown packet type.
 */
int packetsize(int action)
{
	switch (action) {
		case GET_WORK: return sizeof(struct getwork);
		case FIRST_WORD: return sizeof(struct firstword);
		case FINISH_WORK: return sizeof(struct finishwork); /* plus the length of the passwords found */
		case GET_CHARSET: return sizeof(struct getcharset);
		case CHARSET_DATA: return sizeof(struct charsetdata);
		case NOW_SLEEP: return sizeof(struct sleep);
	}
	return -1;
}
