/*
 * This file is part of Distributed John,
 * Copyright (C) 2001-2003 by Luis Parravicini
 * http://ktulu.com.ar
 */

#include "word.h"

extern int getopt(int argc, char * const argv[], const char *optstring);
extern char *optarg;
extern int optind;

#define SERVER_PORT	40000

#define UNDEF_SLEEP	-1

/* possible actions for client/server commnucation */

/*  client requesting a packet of work */
#define GET_WORK	0

/*  GET_WORK answer */
#define FIRST_WORD	1

/*  sent by the client to notify the server a certain packet of work
    has been processed
*/
#define FINISH_WORK	2

/* sent by the client at startup to get the current charset */
#define GET_CHARSET	3

/* GET_CHARSET answer */
#define CHARSET_DATA	4

/* sent by the server if there's no available work, telling the client how much
 * to wait (in seconds) before asking again for more work
 */
#define NOW_SLEEP	5

int packetsize(int);

struct getwork {
	char	action;
};

struct firstword {
	char		action;
	long int	unit_id;
	struct word	word1;
	struct word	word2;
};

/* passwords come after this struct as asciiz strings */
struct finishwork {
	char		action;
	int		size;		/* packet size (including the passwords) */
	long int	unit_id;
	int		cracked;	/* how many passwords were found */
};

struct getcharset {
	char	action;
};

struct charsetdata {
	char		action;
	unsigned char	length;
	unsigned char	charset[256];
};

struct sleep {
	char		action;
	long		secs;
};
