/*
 * This file is part of Distributed John,
 * Copyright (C) 2001-2003 by Luis Parravicini
 * http://ktulu.com.ar
 */
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>

#include "defs.h"
#include "netutils.h"
#include "word.h"
#include "intl.h"

extern char *strdup(const char *s);

#define POT 	"/john.pot"
#define INI 	"/john.ini"
#define RESTORE "/restore"
#define JHOME   "./john/run"
#define DJHOME  "DJHOME"
#define SCRIPT	"/dJohn"
#define CMD1	"/john -e:dJohn "
#define CMD2	"/passwd* >/dev/null 2>&1"
#define SLEEP_TIME	120

/* used by getcharset */
#define ERR_IO		-1
#define ERR_OTHER	-2

time_t	unit_id;
struct in_addr servidor;
char *fini, *djhome = NULL, *jhome = NULL, *jpot, *jini, *jrestore, *jcmd,
	*jfscript, *jscript;
int verbose = 0;

/**
 * returns a string containing the char, or a string with that char quoted with
 * \ if the char is \ or '
 * The string returned should not be modified and it can change from call to
 * call.
 */
char* quoteChar(char c)
{
	static char s[3];
	unsigned char i = 0;

	if (c == '\\' || c == '\'') {
		s[0] = '\\';
		i++;
	}
	s[i] = c;
	s[i+1] = 0;

	return s;
}

/* obtains the charset to use from the server */
int getcharset(int sok)
{
	int leido;
	struct sockaddr_in sa;
	struct getcharset gcs;
	struct charsetdata cd;

	memset((char *)&sa, 0, sizeof(sa));
	sa.sin_family = AF_INET;
	sa.sin_addr = servidor;
	sa.sin_port = htons(SERVER_PORT);
	gcs.action = GET_CHARSET;
	if ((leido=sendmessage(sok, &gcs, sizeof(struct getcharset), &sa, &cd,
	sizeof(cd), 1)) < 0)
		return ERR_IO;
	if (leido < 2) {
		fprintf(stderr, _("read less than 2 bytes!! (%d)\n"), leido);
		return ERR_OTHER;
	}
	if (cd.action != CHARSET_DATA) {
		fprintf(stderr, _("expecting CHARSET_DATA and received "\
			"something else (%d)\n"), cd.action);
		return ERR_OTHER;
	}
	if (leido != cd.length+2) {
		fprintf(stderr, _("packet inconsistency (%d)\n"), leido);
		return ERR_OTHER;
	}
	if ((charset=(unsigned char *)malloc(sizeof(unsigned char)*cd.length)) == NULL) {
		fprintf(stderr, _("not enough memory\n"));
		return ERR_OTHER;
	}
	charsetl = cd.length;
	memcpy(charset, cd.charset, charsetl);
	return 0;
}

/*
 * returns the identification of symbol s or -1 in case s is not a kown symbol.
 */
#define SYMB_CHARSET_LENGTH	0
#define SYMB_MAX_WORD		1
#define SYMB_LENGTH_WORD_1	2
#define SYMB_CHARSET		3
#define SYMB_WORD_1		4
#define SYMB_EQ_WORD_2		5
#define SYMB_NOT_FOUND		-1
int get_symbol_id(const char* s)
{
	int MAX = 6;
	char* symbols[6] = {"charset_length", "max_word", "length_word_1",
		"charset", "word_1", "eq_word_2"};  
	int i;

	for (i = 0; i < MAX; i++)
		if (strcmp(symbols[i], s) == 0)
			return i;
	return SYMB_NOT_FOUND;
}

/*
 * creates john.ini using the contents of the file pointed by fini and adding
 * the external mode to process the work packet.
 */
int mkini(struct word *w1, struct word *w2)
{
	FILE *in = fopen(fini, "r"), *out;
	char buf[8192], *aux0, *aux1, *aux2;
	int i, sid;

	if (in == NULL) {
		fprintf(stderr, _("can't open %s\n"), fini);
		return -1;
	}
	if ((out=fopen(jini, "w")) == NULL) {
		fprintf(stderr, _("can't create john.ini\n"));
		return -1;
	}
	while (fgets(buf, sizeof(buf), in) != NULL)
		if (fputs(buf, out) == EOF) {
			fprintf(stderr, _("error copying ini contents.\n"));
			return -1;
		}
	fclose(in);

	aux0 = jscript;
	while ((aux1=strchr(aux0, '@')) != NULL) {
		if ((aux2=strchr(aux1+1, '@')) == NULL) break;
		*aux1 = 0;
		if (fwrite(aux0, strlen(aux0), 1, out) != 1) {
			*aux1 = 0;
			fprintf(stderr, _("error creating external mode.\n"));
			return -1;
		}
		*aux1 = '@';
		*aux2 = 0;
		buf[0] = 0;
		sid = get_symbol_id(aux1+1);
		/* fixme: no boundaries checking for buf */
		switch (sid) {
			case SYMB_CHARSET_LENGTH:
				sprintf(buf, "%d", charsetl);
				break;
			case SYMB_MAX_WORD:
				sprintf(buf, "%d", MAX_WORD);
				break;
			case SYMB_LENGTH_WORD_1:
				sprintf(buf, "%d", wordlen(w1));
				break;
			case SYMB_CHARSET:
				for (i = 0; i < charsetl; i++)
					sprintf(&buf[strlen(buf)],
					"  charset[%d] = '%s';\n",
					i, quoteChar(charset[i]));
				break;
			case SYMB_WORD_1:
				for (i = 0; i < wordlen(w1); i++)
					sprintf(&buf[strlen(buf)],
					"  word[%d] = '%s';  rword[%d] = %d;\n",
					i, quoteChar(charset[w1->data[i]]),
					i, w1->data[i]);
				sprintf(&buf[strlen(buf)], "  word[%d] = 0;\n",
					wordlen(w1));
				break;
			case SYMB_EQ_WORD_2:
				for (i = 0; i < wordlen(w2); i++) {
					if (i) strcat(buf, " && ");
					sprintf(&buf[strlen(buf)],
					"word[%d] == '%s'", i,
					quoteChar(charset[w2->data[i]]));
				}
				break;
			case SYMB_NOT_FOUND:
				fprintf(stderr, _("unknown symbol (%s)\n"),
					aux1);
				*aux2 = '@';
				return -1;
				break;
			default:
				fprintf(stderr, _("missing symbol substitution"\
					" (%d)\n"), sid);
				*aux2 = '@';
				return -1;
		}
		*aux2 = '@';
		aux0 = aux2+1;
		if (fwrite(buf, strlen(buf), 1, out) != 1) {
			fprintf(stderr, _("error creating external mode.\n"));
			return -1;
		}
	}
	if (fwrite(aux0, strlen(aux0), 1, out) != 1) {
		fprintf(stderr, _("error creating external mode.\n"));
		return -1;
	}

	fclose(out);

	return 0;
}

/* process the work packet and send the results to the server */
int crack(struct in_addr servidor, int socket, struct word *w1, struct word *w2)
{
	int r;
	struct sockaddr_in sa;
	struct finishwork *fw;
	FILE *in;
	char s[8192], passwd[51200+sizeof(struct finishwork)];
	unsigned char *aux;
	int pos, l;

	if ((r=mkini(w1, w2))) return r;
	unlink(jrestore);
	/* FIXME: hacer con un fork/execxxxx para mejor control y poder renovar
	 * el paquete con el servidor.
	 */
	r = system(jcmd);
	if (r == -1) {
		perror("system");
		return -1;
	}
	if (WEXITSTATUS(r) != 0) {
		char s[1024]; /* this SHOULD suffice */
		sprintf(s, _("an error occured running john (exit code %u)\n"),
			WEXITSTATUS(r));
		fprintf(stderr, s);
		return -1;
	}

	if ((in=fopen(jrestore, "r")) != NULL) {
		fclose(in);
		fprintf(stderr, _("john died when it shouldn't!!!\n"));
		return -1;
	}

	/* obtains the passwords cracked */
	if ((in=fopen(jpot, "r")) == NULL) {
		sa.sin_addr = servidor;
		if (verbose)
			printf("%s\tCRACKED\t%ld\tdone. got 0\n",
				inet_ntoa(sa.sin_addr), (long) unit_id);
		return 0;
	}
	pos = sizeof(struct finishwork);
	fw = (struct finishwork *)passwd;
	fw->cracked = 0;
	while (fgets(s, sizeof(s), in) != NULL)
		if ((aux=strchr(s, ':')) != NULL) {
			aux++;
			if (aux[strlen(aux)-1] == '\n') aux[strlen(aux)-1] = 0;
			l = strlen(aux);
			if (pos+l+1 >= sizeof(passwd)) {
				fprintf(stderr, _("too many passwords found."\
					"keeping john.pot\n"));
				break;
			} else {
				strcpy(&passwd[pos], aux);
				pos += strlen(aux)+1;
				fw->cracked++;
			}
		}
	fclose(in);

	/* send the passwords to the server */
	memset((char *)&sa, 0, sizeof(sa));
	sa.sin_family = AF_INET;
	sa.sin_addr = servidor;
	sa.sin_port = htons(SERVER_PORT);
	fw->action = FINISH_WORK;
	fw->size = pos;
	fw->unit_id = unit_id;
	if (verbose)
		printf("%s\tCRACKED\t%ld\tdone. got %d\n",
			inet_ntoa(sa.sin_addr), (long) unit_id, fw->cracked);
	if (sendmessage(socket, fw, pos, &sa, NULL, 0, 0) < 0) {
  		qerror("");
		return -1;
	}

	unlink(jpot);

	return 0;
}

void opt_init(int argc, char **argv)
{
	int i, ip;
	struct hostent *h;

	ip = 0;
	while ((i=getopt(argc, argv, "d:j:vh")) != -1) {
		switch (i) {
			case 'd':
				djhome = optarg;
				break;
			case 'j':
				jhome = optarg;
				break;
			case 'v':
				verbose++;
				break;
			case 'h':
				printf("Distributed John\n");
				printf("Copyright (C) 2001-2003 Luis Parravicini\n\n");
				printf(_("usage: djohn [options] server\n"));
				printf(_("-d : where is john-ini and the password files\n"));
				printf(_("-j : where is John The Ripper (default: ./john/run)\n"));
				printf(_("-v : be verbose\n"));
				printf(_("-h : this help message\n"));
				exit(0);
		}
	}
	if (optind < argc) {
		if ((h=gethostbyname(argv[optind])) == NULL) {
			fprintf(stderr, _("cannot resolve server name\n"));
			exit(1);
		}
		servidor = *(struct in_addr *)h->h_addr_list[0];
	} else  {
		fprintf(stderr, _("you must specify the server to connect to\n"));
		exit(1);
	}
	if (jhome == NULL)
		jhome = strdup(JHOME);
}

char* strdupcat(char *s1, char *s2)
{
	char *s;

	if ((s=(char *)malloc(strlen(s1)+strlen(s2)+1)) == NULL) {
		fprintf(stderr, _("not enough memory\n"));
		return NULL;
	}
	strcpy(s, s1); 
	return strcat(s, s2);
}

int first_word(char *buf, struct sockaddr_in *sa, int sok2)
{
	struct firstword *fw;
	char s[MAX_WORD], s1[MAX_WORD];

	fw = (struct firstword *)buf;
	if (verbose)
		printf("%s\tFIRST_WORD\t%s\t%s\n", inet_ntoa(sa->sin_addr),
			wordtostr(&fw->word1, &s[0]),
			wordtostr(&fw->word2, &s1[0]));
	unit_id = fw->unit_id;
	if (crack(servidor, sok2, &fw->word1, &fw->word2)) {
		fprintf(stderr, _("An error occurred during cracking, "\
			"exiting...\n"));
		return 1;
	}

	return 0;
}

void now_sleep(char *buf, struct sockaddr_in *sa)
{
	struct sleep *sl;

	sl = (struct sleep *)buf;
	if (verbose)
		printf("%s\tSLEEP\t%ld\n", inet_ntoa(sa->sin_addr), sl->secs);
	if (sl->secs == UNDEF_SLEEP)
		sleep(SLEEP_TIME);
	else
		sleep(sl->secs);
}

/* loads the external mode source code into a string */
int load_code(const char *fname)
{
	long size;
	FILE *f = fopen(fname, "r");

	if (f == NULL) {
		fprintf(stderr, "load_code: can't open %s\n", fname);
		return 1;
	}
	if (fseek(f, 0, SEEK_END) == -1) {
		perror("load_code");
		fclose(f);
		return 1;
	}
	if ((size=ftell(f)) == -1) {
		perror("load_code");
		fclose(f);
		return 1;
	}
	if (fseek(f, 0, SEEK_SET) == -1) {
		perror("load_code");
		fclose(f);
		return 1;
	}
	if ((jscript=malloc(size)) == NULL) {
		fprintf(stderr, "load_code: no mem\n");
		fclose(f);
		return 1;
	}
	if (fread(jscript, 1, size, f) != size) {
		perror("load_code");
		fclose(f);
		return 1;
	}
	if (fclose(f)) {
		perror("load_code");
		return 1;
	}
	return 0;
}

int main(int argc, char *argv[])
{
	struct sockaddr_in sa;
	char buf[512];
	struct getwork gw;
	int sok2, i;
	char *aux;

	init_i18n();
	opt_init(argc, argv);
	if (djhome == NULL && (djhome=getenv(DJHOME)) == NULL) {
		fprintf(stderr, _("-d not specified and $DJHOME is not set\n"));
		return 1;
	}
	if ((fini=strdupcat(djhome, "/john-ini")) == NULL) return 1;
	if ((jpot=strdupcat(jhome, POT)) == NULL) return 1;
	if ((jini=strdupcat(jhome, INI)) == NULL) return 1;
	if ((jrestore=strdupcat(jhome, RESTORE)) == NULL) return 1;
	if ((jcmd=strdupcat(jhome, CMD1)) == NULL) return 1;
	aux = jcmd;
	if ((jcmd=strdupcat(jcmd, djhome)) == NULL) return 1;
	free(aux);
	aux = jcmd;
	if ((jcmd=strdupcat(jcmd, CMD2)) == NULL) return 1;
	free(aux);
	if ((jfscript=strdupcat(djhome, SCRIPT)) == NULL) return 1;
	if (load_code(jfscript)) return 1;

/*    if (nice(20)) fprintf(stderr, "can't set priority to 20\n"); */

	if ((sok2=socket(AF_INET,SOCK_DGRAM,IPPROTO_UDP))==-1){
		fprintf(stderr, "can't create socket\n");
		return 1;
	}

	while (1) {
		if ((i=getcharset(sok2))) {
			if (i == ERR_IO)
				qerror(_("can't get charset from server"));
			else {
				fprintf(stderr, _("can't get charset from "\
					"server"));
				fprintf(stderr, "\n");
			}
			fprintf(stderr, _("sleeping before retrying...\n"));
			sleep(SLEEP_TIME);
		} else
			if (!i) break;
	}
	do {
		memset((char *)&sa, 0, sizeof(sa));
		sa.sin_family = AF_INET;
		sa.sin_addr = servidor;
		sa.sin_port = htons(SERVER_PORT);
		gw.action = GET_WORK;
		if (sendmessage(sok2, &gw, sizeof(gw), &sa, &buf, sizeof(buf),
		1) < 0) {
			qerror(_("sleeping before retrying..."));
			sleep(SLEEP_TIME);
			continue;
		}
		switch (buf[0]) {
			case FIRST_WORD:
				if (first_word(buf, &sa, sok2))
					return -1;
				break;
			case NOW_SLEEP:
				now_sleep(buf, &sa);
				break;
			default:
				fprintf(stderr, _("%s\tunknown packet type "\
					"(%d)\n"), inet_ntoa(sa.sin_addr),
					buf[0]);
		}
		sleep(2);
	} while (1);

	return 0;
}
