/*
 * This file is part of Distributed John,
 * Copyright (C) 2001-2003 by Luis Parravicini
 * http://ktulu.com.ar
 */

#define _XOPEN_SOURCE

#include <stdio.h>
#ifdef __FreeBSD__
#include <sys/types.h>
#endif
#include <sys/ipc.h>
#include <sys/shm.h>

#include "ipc.h"


char* newshmbuff(key_t key, int *shmid, int size, int create)
{
	char *buf;

	if ((*shmid=shmget(key, size, (create ? (IPC_CREAT|IPC_EXCL|IPC_PERMS) : 0))) == -1) {
		perror("shmget");
		return NULL;
	}
	if (*(int *)(buf=shmat(*shmid, 0, 0)) == -1) {
		perror("shmat");
		return NULL;
	}

	return buf;
}
