/*
 * This file is part of Distributed John,
 * Copyright (C) 2001-2003 by Luis Parravicini
 * http://ktulu.com.ar
 */
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <arpa/inet.h>

#include "netutils.h"
#include "intl.h"

const char *err_list[] = {
	gettext_noop("No error"),
	gettext_noop("An error occurred sending data"),
	gettext_noop("An error occurred receiving data"),
	gettext_noop("Not all the data was sent"),
	gettext_noop("zero bytes read!"),
	gettext_noop("Timeout while waiting for server's answer")
};
int erridx;

int mkserver(struct in_addr *listen, in_port_t port)
{
	int s;
	struct sockaddr_in sa;

	if ((s = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP)) == -1) {
		fprintf(stderr, _("Can't create socket\n"));
		return -1;
	}
	memset(&sa, 0, sizeof(sa));
	sa.sin_family = AF_INET;
	sa.sin_addr = *listen;
	sa.sin_port = htons(port);
	if (bind(s, (struct sockaddr *)&sa, sizeof(sa)) == -1) {
		fprintf(stderr, _("Can't bind to %s\n"), inet_ntoa(sa.sin_addr));
		return -1;
	}

	return s;
}

int sendmessage(int s, const void *msg, int len,
	const struct sockaddr_in *to,
	void *buf, int buf_len, int wait_for_answer)
{
	fd_set rfds;
	struct timeval tv;
	int leido, escrito;

	if ((escrito=sendto(s, msg, len, 0, (struct sockaddr *)to,
	sizeof(struct sockaddr_in))) == -1)
		return erridx = ERR_SENDING;

	if (escrito != len)
		return erridx = ERR_LESS;

	if (wait_for_answer) {
		FD_ZERO(&rfds);
		FD_SET(s, &rfds);
		tv.tv_sec = 15;
		tv.tv_usec = 0;
		if (select(s+1, &rfds, NULL, NULL, &tv) == 1) {
			if ((leido=recvfrom(s, buf, buf_len, 0, NULL, NULL)) == -1)
				return erridx = ERR_RECVING;

			if (leido < 1)
				return erridx = ERR_LESS2;
		} else
			return erridx = ERR_TIMEOUT;
	} else
		leido = 0;

	erridx = 0;
	return leido;
}
