/*
 * This file is part of Distributed John,
 * Copyright (C) 2001-2003 by Luis Parravicini
 * http://ktulu.com.ar
 */
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "word.h"
#include "intl.h"

/* crea el conjunto de caracteres a usarse. Es una cadena donde cada caracter
   se incluye en el conjunto y se permiten rangos con - (e.g. a-z). Para
   incluir el -, ponerlo al principio o al final. Si un caracter que ya esta
   incluido se menciona de vuelta se ignora y si los rangos son invalidos
   (e.g. z-a) no pasa nada
   Devuelve el tamao del conjunto.
*/
int mkcharset(unsigned char *s)
{
	unsigned char cset[256], *aux = s;
	int i, prev = -1;

	memset(cset, 0, sizeof(cset));
	while (*aux) {
		if (*aux == '-')
			if (s == aux || !*(s+1))
				cset[*aux] = 1;
			else
				prev = *(aux-1);
		else
			if (prev != -1) {
				for (i = prev; i <= *aux; i++)
					cset[i] = 1;
				prev = -1;
			} else
				cset[*aux] = 1;
		aux++;
	}
	for (i = charsetl = 0; i <= 255; i++)
		if (cset[i]) charsetl++;
	charset = (unsigned char *)malloc(sizeof(unsigned char)*charsetl);
#ifdef DEBUGGING
	printf("set size= %d\nset=[", charsetl);
#endif
	for (i = prev = 0; i <= 255; i++)
		if (cset[i])
#ifdef DEBUGGING
		{
		printf(",%c",i);
#endif
			charset[prev++] = i;
#ifdef DEBUGGING
		}
		printf("]\n");
#endif
	return charsetl;
}


/* como el strcmp(3) pero para struct word */
int wordcmp(struct word w1, struct word w2)
{
	int i, min;

	if (w1.length < w2.length) return -w1.length;
	else
	if (w1.length > w2.length) return w2.length;

	min = (w1.length < w2.length ? w1.length : w2.length);
	for (i = 0; i < min; i++)
		if (w1.data[i] > w2.data[i]) return i+1;
		else
			if (w1.data[i] < w2.data[i]) return -i-1;
	return 0;
}

/*
 * Convierte un string a un struct word.
 * Pone por cada char de w el indice que le corresponde dentro de charset en el arreglo i
 * devuelve 0 con exito, INVALID_CHAR fracaso. En ambos casos modifica w.
 * Si la long de s es >= MAX_WORD devuelve STR_TOO_LONG y no modifica w.
 */
int strtoword(char *s, struct word *w)
{
	int i;

	if (s == NULL) return NULL_STR;
	if (strlen(s) >= MAX_WORD) return STR_TOO_LONG;
	w->length = 0;
	while (*s) {
		for (i = 0; i < charsetl && charset[i] != *s; i++);
		if (i == charsetl) return INVALID_CHAR;
		w->data[w->length++] = i;
		s++;
	}
	return 0;
}

/*
 * inversa de strtoword
 * supone que s tiene suficiente espacio (w.length+1)
 * devuelve s
 */
char* wordtostr(struct word *w, char *s)
{
	int i;

	for (i = 0; i < w->length; i++) s[i] = charset[w->data[i]];
	s[i] = 0;
	return s;
}

int wordlen(struct word *w) { return w->length; }

void show_error(int err, char *s)
{
	if (s != NULL) fprintf(stderr, s);
	switch (err) {
		case STR_TOO_LONG:
      			fprintf(stderr, _("string too long\n"));
			break;
		case INVALID_CHAR:
      			fprintf(stderr, _("the string has characters that doens't belong to the charset\n"));
			break;
		case NULL_STR:
      			fprintf(stderr, _("null string\n"));
			break;
		default:
			fprintf(stderr, _("unknown error (%d)\n"), err);
	}
}
