/*
 * Dnetj client
 * (C) 2007 john@ev6.net
 *
 */

static const char rcsid[] =
  "$Id: client.c,v 1.25 2007/07/18 08:49:07 bert Exp $";

#define _FORTIFY_SOURCE 2

#include "dnetj.h"
#include "client.h"
#include "setjmp.h"

/* global vars */
unsigned int protover = 1;	/* default protocol version */
int highest_fd;
struct sockinf *headsockinf = NULL;
int sc[2048];
char readbuf[4096];
char prbuf[4096];
int MAXFD;
int regallow = 0;
unsigned short bindport = DEFPORT;
unsigned int shuttingdown = 0;
char *config = NULL;		/* config file name */
char loadwork[64];		/* a filename to load work from */
unsigned int latestunit = 0;	/* The last unit generated */
char *hashfile = NULL;		/* the hash file */
char *workinghash = NULL;	/* the work in progress hash */
unsigned int unitsize = DEFUNITSIZE;	/* default size of a work unit */
unsigned int unitbuffers = UNIT_BUFFER;	/* default number of units to buffer */
char *savefile;			/* where to save our progress */
char *server;			/* the server to connect to */
int maxunits = 5;		/* maximum units per node */
unsigned int client = 1;	/* are we a client */
unsigned int read_finished;	/* have we finished our network reading */
extern struct unit *headunit;
unsigned int myid = 0;		/* our node ID */
char *mypass;			/* our node password */
char sendbuf[SENDBUF_SIZE];
unsigned int sock;		/* socket descriptor */
extern unsigned int socktimeout;
jmp_buf jump_back;

void
usage ()
{
  printf ("Wrong usage\n");
}

void
timed_out (int sig)
{
  longjmp (jump_back, 0x0);
}

/* heres where it all happens */
void
mainloop ()
{
  unsigned int x = 0;

  while (1)
    {
      x = count_pending ();	/* first check if we have work to do */
      if (x > 0)
	{
	  printf ("There are %d outstanding work units, processing\n", x);
	  process_work ();
	}
      else
	{			/* if not, download some */
	  printf ("Proceeding to download new work units\n");
	  if (readloop () != 0)
	    {			/* the read loop failed somehow, connection refused or such */
	      printf ("Reading from server failed, sleeping\n");
	      sleep (WAIT_TIME);
	    }
	}
    }

}

int
readloop ()
{
  fd_set read_set, write_set;
  int res, i, nfds;
  signed int x = 0, errors = 0;
  char *tptr, *ttptr;
  struct sockinf *currsockinf;
  struct timeval tv;
  struct sockinf *s;

  read_finished = 0;

  if (server == NULL)
    {
      printf ("FATAL ERROR - No server specified\n");
      exit (-1);
    }

  if (sock > 0)
    {
      close (sock);
    }

  sock = do_connect (server, bindport);

  if (sock != -1)
    {
      s = newsockinf ();
      s->sock = sock;
      s->last = time (NULL);
      addsockinf (s);
    }
  else
    {
      return -1;
    }

  while (1)
    {
/* one line per iteration */
      check_timeouts (sock);
      if (read_finished == 1)
	{
	  killsockinf (sock);
	  close (sock);
	  return 0;
	}
      for (res = 0;;)
	{
	  FD_ZERO (&read_set);
	  FD_ZERO (&write_set);

	  if (headsockinf == NULL)
	    {
	      return -1;
	    }

	  currsockinf = headsockinf;

	  highest_fd = 0;
	  while (currsockinf != NULL)
	    {
	      FD_SET (currsockinf->sock, &read_set);
	      FD_SET (currsockinf->sock, &write_set);
	      if (highest_fd < currsockinf->sock)
		highest_fd = currsockinf->sock;

	      currsockinf = currsockinf->next;
	    }

	  if (highest_fd == 0)
	    {
	      printf ("Socket disconnected\n");
	      return -1;
	    }
	  tv.tv_sec = 5;
	  tv.tv_usec = 0;
	  nfds = select ((highest_fd + 1), &read_set, &write_set, NULL, &tv);
	  if (nfds >= 0)
	    break;
	  perror ("select");
	  errors++;
	  fflush (stdout);
/* too many errors */
	  if (errors >= 2)
	    {
	      killsockinf (sock);
	      close (sock);
	      return 0;
	    }
	  sleep (1);
	}
      currsockinf = headsockinf;

      while (currsockinf != NULL)
	{
	  i = currsockinf->sock;
	  if (FD_ISSET (i, &read_set) && (i != STDIN))
	    {
	      FD_CLR (i, &read_set);
	      memset (readbuf, 0, sizeof (readbuf));
#ifdef EBUG
	      printf ("Reading from sock: %d\n", currsockinf->sock);
#endif
	      x = read (i, readbuf, sizeof (readbuf));
	      if (x <= 0)
		{
		  close (i);
		  printf ("dead sock: %d\n", i);
/* destroy the struct sockinf */
		  killsockinf (i);
		  sc[i] = -1;
		  return -1;
		}
	      else
		{
/* cheesy parsing */
/* what if we get a partial line.... */
#ifdef EBUG
		  printf ("DEBUG: read %d chars, readbuf is %d at %p\n",
			  x, sizeof (readbuf), readbuf);
		  printf ("DEBUG SOCK %d RECV: %s|||END\n", i, readbuf);
#endif
		  currsockinf->last = time (NULL);
		  tptr = NULL;
		  ttptr = readbuf;
		  tptr = strchr (readbuf, '\n');	/* find the \n */
		  while (tptr != NULL)
		    {
		      *tptr = 0;	/* zero out the \n */
#ifdef EBUG
		      printf ("DEBUG LINE SOCK %d: %s\n", i, ttptr);
#endif
		      snprintf (prbuf, sizeof (prbuf), "%s", ttptr);
		      procbuf (prbuf, i);
		      tptr++;
		      ttptr = tptr;	/* new is old */
		      tptr = strchr (ttptr, '\n');	/* next */
		    }
		}
	    }
/* write was here */
	  currsockinf = currsockinf->next;
	}
    }
}


int
main (int argc, char *argv[])
{
/* for readfile parsing */
  FILE *fil;

  client = 1;
/* NULL the fresh linked lists */
  headsockinf = NULL;

  srand (time (NULL));
  srandom (time (NULL));

  banner ();

/* open the config file */
  fil = fopen (argv[1], "r");

  if (fil == NULL)
    {
      usage ();
      exit (0);
    }
  fclose (fil);

  config = (void *) calloc (1, strlen (argv[1]) + 1);

  strncpy (config, argv[1], strlen (argv[1]));

/* load the data files */
  loadfile ();

  printf ("Entering main loop\n");
  mainloop ();
  return 0;
}

int
do_connect (char *hstname, unsigned short port)
{
  signed int s = -1;
  unsigned int yes = 1;
  struct hostent *he;
  struct sockaddr_in sin;

  s = socket (AF_INET, SOCK_STREAM, 0);
  setsockopt (s, SOL_SOCKET, SO_REUSEADDR, &yes, sizeof (int));
  if (s < 0)
    return -2;
  memset (&sin, 0, sizeof (struct sockaddr_in));
  sin.sin_family = AF_INET;
  sin.sin_port = htons (port);
  sin.sin_addr.s_addr = inet_addr (hstname);
  if (sin.sin_addr.s_addr == INADDR_NONE)
    {
      he = gethostbyname (hstname);
      if (!he)
	{
	  close (s);
	  return -1;
	}
      memcpy (&sin.sin_addr, he->h_addr, he->h_length);
    }

  signal (SIGALRM, timed_out);
  alarm (socktimeout);

  if (setjmp (jump_back) == 0x0)
    {
      if (connect (s, (struct sockaddr *) &sin, sizeof (sin)) < 0)
	{
	  alarm (0);
	  close (s);
	  perror ("connect");
	  return -1;
	}
      alarm (0);
    }
  else
    {
      printf ("Connection timed out\n");
      alarm (0);
      return -1;
    }
  if (s > highest_fd)
    highest_fd = s;
  return s;
}

void
process_work ()
{
  struct unit *proc;
  FILE *chk;

  printf ("Processing work\n");

  proc = get_pending ();

  while (proc != NULL)
    {
      printf ("Processing unit %d\n", proc->id);
      write_recfile (proc, "john.rec");

      system ("./john -restore >/dev/null 2>&1");
      printf ("John process finished\n");
      chk = fopen ("john.rec", "r");

      if (chk != NULL)
	{			/* the file is still there, something went wrong */
	  printf
	    ("The john.rec file is still present, something went wrong\n");
	}
      else
	{
	  printf ("Unit completed %d\n", proc->id);
	  proc->status = UNIT_COMPLETE;
	}
      save_units ();
      proc = get_pending ();	/* next unit or NULL, or same unit if error */
    }
  return;
}
