/* Load a file
 */

static const char rcsid[] =
  "$Id: clientconf.c,v 1.7 2007/07/17 20:52:26 bert Exp $";

#include "dnetj.h"
#include "client.h"

extern int regallow;
extern int highest_node;
extern unsigned short bindport;
extern int maxunits;
extern unsigned int latestunit;
extern int client;

extern char *config;
extern char *hashfile;
extern char *workinghash;
extern char *savefile;
extern char *server;

extern unsigned int unitsize;
extern struct unit *headunit;
extern unsigned int socktimeout;

extern int myid;
extern char *mypass;

char *authfile;

/* stuff the client needs to load */
int
loadfile ()
{
  load_conf ();
  load_hashes ();
  loadworkfile (savefile);
  load_auth ();
  return 0;
}

/* load_auth() - load authentication details 		*/
/* authfile is defined from the config			*/
/* if authfile is null, use a default 			*/
void
load_auth ()
{
  char readbuf[1024], *p = NULL, *cmd = NULL, *parms = NULL;
  FILE *fil;

  if (authfile == NULL)
    {
      fil = fopen (AUTH_DEFAULT, "r");
    }
  else
    {
      fil = fopen (authfile, "r");
    }

  if (fil == NULL)
    {
      printf ("Error opening auth file\n");
      return;
    }

  fgets (readbuf, sizeof (readbuf), fil);

/* chop off any trailing \r\n */
  p = strchr (readbuf, '\n');
  if (p != NULL)
    p[0] = 0;

  p = strchr (readbuf, '\r');
  if (p != NULL)
    p[0] = 0;


/* the middle point */
  cmd = readbuf;
  p = strchr (readbuf, ' ');

  if (p != NULL)
    {
      p[0] = 0;
      parms = p + 1;
    }

  if (mypass != NULL)
    {
      free (mypass);
    }

  myid = atoi (cmd);
  mypass = (char *) calloc (1, strlen (parms) + 2);
  strncpy (mypass, parms, strlen (parms));

  if (fil != NULL)
    {
      fclose (fil);
    }

}


void
prcfg (buf)
     char buf[4096];
{
  char *cmd = NULL, *parms = NULL, *p = NULL;

  p = strchr (buf, '\n');
  if (p != NULL)
    p[0] = 0;

  p = strchr (buf, '\r');
  if (p != NULL)
    p[0] = 0;

  cmd = buf;

  p = strchr (buf, ' ');

  if (p != NULL)
    {
      p[0] = 0;
      parms = p + 1;
    }


  if (!strncasecmp (cmd, "PORT", 4))
    {
      bindport = atoi (parms);
      printf ("Connecting to port %d \n", bindport);
      return;
    }
  else if (!strncasecmp (cmd, "MAXUNITS", 8))
    {
      maxunits = atoi (parms);
      printf ("Requesting a maximum of %d units\n", maxunits);
      return;
    }
  else if (!strncasecmp (cmd, "TIMEOUT", 7))
    {
      socktimeout = atoi (parms);
      printf ("Setting socket timeout to %d seconds\n", socktimeout);
      return;
    }
  else if (!strncasecmp (cmd, "WORKHASH", 8))
    {
      workinghash = (char *) calloc (1, strlen (parms) + 2);
      snprintf (workinghash, strlen (parms) + 1, "%s", parms);
      printf ("Using working hash file %s \n ", workinghash);
      return;
    }
  else if (!strncasecmp (cmd, "SAVEFILE", 8))
    {
      savefile = (char *) calloc (1, strlen (parms) + 2);
      snprintf (savefile, strlen (parms) + 1, "%s", parms);
      printf ("Using work unit save file %s \n", savefile);
      return;
    }
  else if (!strncasecmp (cmd, "SERVER", 6))
    {
      server = (char *) calloc (1, strlen (parms) + 2);
      snprintf (server, strlen (parms) + 1, "%s", parms);
      printf ("Using server %s \n", server);
      return;
    }
  else if (!strncasecmp (cmd, "AUTHFILE", 8))
    {
      authfile = (char *) calloc (1, strlen (parms) + 2);
      snprintf (authfile, strlen (parms) + 1, "%s", parms);
      printf ("Using authentication cache %s \n", authfile);
      return;
    }

}

/* save authentication details */
void
save_auth ()
{
  FILE *fil;

  if ((myid != 0) & (mypass != NULL))
    {
      if (authfile == NULL)
	{
	  fil = fopen (AUTH_DEFAULT, "w");
	}
      else
	{
	  fil = fopen (authfile, "w");
	}
      if (fil == NULL)
	{
	  printf ("Error opening auth file\n");
	  return;
	}
      fprintf (fil, "%d %s\n", myid, mypass);
      fclose (fil);
    }

  return;
}
