#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <netdb.h>
#include <fcntl.h>
#include <errno.h>
#include <signal.h>
#include <sys/time.h>
#include <arpa/inet.h>
#include <time.h>

#include "modes.h"
#include "units.h"
#include "version.h"

/* max length of parameters and commands */

#define CMDLEN 32
#define PARAMLEN 1024
#define STDIN 0
#define DEFPORT 8020
/* size of a work unit, defined here for now, commandline later */
/* this is overwritten by a save file */
#define DEFUNITSIZE 500000

/* units to buffer */
#define UNIT_BUFFER 5

/* default filenames */
#define NODEFILE "dnetj.nodes"

#define SENDBUF_SIZE 1024

/* default socket timeout (seconds) */
#define TIMEOUT_DEFAULT 10

/* linked list for sockets */
struct sockinf
{
  unsigned int sock;
  unsigned int dead;
  unsigned int mode;
  unsigned int regd;
  unsigned int last;		/* last seen traffic */
  struct node *thisnode;
  unsigned int ip;
  struct sockinf *next;
};

/* function declarations */
void parsemsg(char *, char *, char *);
void register_client (struct sockinf *);
struct sockinf *findsockinf(int);
int loadfile ();
int client_loadfile ();
int openlisten (unsigned short);
int killsockinf (int);
void addsockinf (struct sockinf *);
struct sockinf * newsockinf();
void socket_status_report();
char * rlookup (unsigned int);
char * nlookup (unsigned int);
void save_status_all();
void procbuf (char[], int);
void banner();
void close_all_sockets();
int load_hashes();
int loadworkfile (char *);
int load_conf();
void check_timeouts (int);
