/* dnetj - genwork.c - server only, generwte work units 
 *
 */

static const char rcsid[] =
  "$Id: genwork.c,v 1.19 2007/07/17 20:52:26 bert Exp $";

#include "dnetj.h"
#include "server.h"

int generating = 0;
extern char loadwork[];
extern unsigned int latestunit;
extern unsigned int unitsize;
extern char *workinghash;
struct unit *headgen;
extern unsigned int genpid;

/* initiate work unit generation */
/* we generate to file, then exit... */
/* On exiting, the parent gets a SIGCHLD */
/* parent then loads data from the loadwork file */

int
genwork (int units, char *file)
{
  char cmdbuf[1024];
  FILE *wfd;
  unsigned int x = 0;
  struct unit *wunit;

  headgen = NULL;

  if (generating == 1)
    {
      return GEN_INPROGRESS;
    }

/* set the global readfile name */
  strncpy (loadwork, file, strlen (file));

/* we are generating work... this will be unset when the child exits */
  generating = 1;

/* find the latest unit, and save the john.rec file */
  wunit = findunit (latestunit);

  if (wunit != NULL)
    {				/* only write the recfile if we actually have one */
      write_recfile (wunit, "john.rec");
    }

#ifndef DEBUG_FORK
  genpid = fork ();

  if (genpid != 0)
    {
      printf ("Forked new process, pid %d to generate %d units\n", genpid,
	      units);
      return GEN_STARTED;
    }
  else
    {
/* we have forked */
#endif
/*      printf ("fork: Beginning unit generation\n"); */

/* reset the head generation pointer */

/* unit generation loop */
      for (x = 1; x <= units; x++)
	{
	  if (latestunit == 0)
	    {
	      wunit = NULL;
/* We initialize the recovery file */
	      snprintf (cmdbuf, sizeof (cmdbuf),
			"./john -keygen:all -max:%d %s >/dev/null 2>&1",
			unitsize, workinghash);
	      system (cmdbuf);	/* we use system because it waits for exit */
	      latestunit++;
	      wunit = newunit ();
	      load_recfile ("john.rec", 0, wunit);
	      wunit->id = latestunit;
	      wunit->size = unitsize;
	      wunit->status = UNIT_BUF;
	      wunit->assigned = 0;
	      wunit->progress = 0;
	      addunitg (wunit);
	    }
	  else
	    {
/* generate next unit */
	      wunit = NULL;
	      latestunit++;
	      snprintf (cmdbuf, sizeof (cmdbuf),
			"./john -restore >/dev/null 2>&1");
	      system (cmdbuf);	/* we use system because it waits for exit */
	      wunit = newunit ();
	      if (wunit == NULL)
		{
		  printf ("DEBUG - newunit returned a null pointer\n");
		}
	      load_recfile ("john.rec", latestunit, wunit);
	      wunit->id = latestunit;
	      wunit->size = unitsize;
	      wunit->status = UNIT_BUF;
	      wunit->assigned = 0;
	      wunit->progress = 0;
	      addunitg (wunit);
	    }
	}
/* here we write out our structures */
      wunit = headgen;

#ifdef EBUG
      printf ("Unit generation status:\n");
      printf ("Latest unit: %d, head is at %p\n", latestunit, wunit);
#endif
      wfd = fopen (loadwork, "w");

      if (wfd == NULL)
	{
	  printf ("Serious error - opening work file\n");
	  return -1;
	}

/* file header */
      fprintf (wfd, "# DNETJ WORKF 1\n");

      while (wunit != NULL)
	{

	  fprintf (wfd, "UNIT:%u:%u:%u:%u:%u\n",
		   wunit->id, wunit->size, wunit->status, wunit->assigned,
		   wunit->progress);
	  fprintf (wfd, "%s\n_EOF_\n", wunit->recfile);

	  wunit = wunit->next;
	}
      fclose (wfd);

/* tell the parent we have new work */
      wfd = fopen ("freshwork", "w");
      fclose (wfd);
      printf ("Generating fork complete, exiting\n");
      exit (0);
#ifndef DEBUG_FORK
    }
  printf ("Generating fork complete, exiting\n");
  exit (0);
#endif
}

/* load a record file into a structure */
int
load_recfile (char *file, int id, struct unit *wunit)
{
  FILE *fd;
  unsigned int size;

  fd = fopen (file, "r");

  if (fd == NULL)
    {
      printf ("File open failed\n");
      return -1;
    }

/* loop to load the file */
  fseek (fd, 0, SEEK_END);
  size = ftell (fd);

#ifdef EBUG
  printf ("DEBUG: Loading %d bytes\n", size);
#endif

  fseek (fd, 0, SEEK_SET);

  wunit->recfile = (void *) calloc (1, size + 2);;

  if (size != fread (wunit->recfile, sizeof (char), size, fd))
    {
      return -1;
    }
  wunit->recfile[size] = 0;

  if (fd != NULL)
    {
      fclose (fd);
    }

  return 0;
}

void
addunitg (struct unit *si)
{
  struct unit *s = headgen, *old = NULL;
  si->next = NULL;
  while (s != NULL)
    {
      old = s;
      s = s->next;
    }
  if (old != NULL)
    {
      old->next = si;
    }
  else
    {
      headgen = si;
    }
}
