/* dnetj - hashes.c - client/server, manipulate the hash lists
 *
 */

static const char rcsid[] =
  "$Id: hashes.c,v 1.10 2007/07/17 20:52:26 bert Exp $";

#include "dnetj.h"
#include "server.h"

struct pwhash *headhash = NULL;
extern char *workinghash;

void
addhash (struct pwhash *si)
{
  struct pwhash *s = headhash, *old = NULL;
  si->next = NULL;
  while (s != NULL)
    {
      old = s;
      s = s->next;
    }
  if (old != NULL)
    {
      old->next = si;
    }
  else
    {
      headhash = si;
    }
}

struct pwhash *
newhash ()
{
  struct pwhash *si;
  si = (struct pwhash *) calloc (1, sizeof (struct pwhash));
  return si;
}

struct pwhash *
findhash (int s)
{
  struct pwhash *currhash;

  currhash = headhash;

  while (currhash != NULL)
    {
      if (currhash->id == s)
	{
	  return currhash;
	}
      currhash = currhash->next;
    }
  return NULL;
}

/* save to the running hashes file */
int
save_hashes ()
{
  FILE *wrt;
  struct pwhash *n;

  n = headhash;

  wrt = fopen (workinghash, "w");

  if (wrt == NULL)
    {
      printf ("Failed to open hash save file!\n");
    }

  printf ("Saving password hashes to file %s\n", workinghash);
  while (n != NULL)
    {
      if (n->plaintext != NULL)
	{
	  fprintf (wrt, "%d:%s:%s:%d:\n", n->id, n->pass, n->plaintext,
		   n->cracked);
	}
      else
	{
	  fprintf (wrt, "%d:%s::%d:\n", n->id, n->pass, n->cracked);
/* debugging cruft
sleep(1);
*/
	}
      n = n->next;
    }

  fclose (wrt);

  printf ("Hashes successfully saved\n");

  return 0;
}

/* search through our john.pot file and mark pre-cracked hashes as cracked */
/* free the hash->plaintext if it's not null */
/* set the hash->plaintext for status output purposes */
void
recheck_hashes ()
{
  char readbuf[1024], *ptr = NULL, *phash = NULL, *pplain = NULL;
  FILE *pot;
  struct pwhash *n;

  pot = fopen ("john.pot", "r");

  if (pot == NULL)
    {
      return;
    }

/* loop here, reading lines  */
  while (fgets (readbuf, sizeof (readbuf), pot))
    {
      ptr = strchr (readbuf, '\n');
      if (ptr != NULL)
	{
	  ptr[0] = 0;
	  ptr = NULL;
	}
      ptr = strchr (readbuf, '\r');
      if (ptr != NULL)
	{
	  ptr[0] = 0;
	  ptr = NULL;
	}

      phash = strtok (readbuf, ":");
      pplain = strtok (NULL, ":");

      if ((pplain != NULL) && (phash != NULL))
	{
	  n = headhash;

	  while (n != NULL)
	    {
	      if (!strncmp (n->pass, phash, strlen (n->pass)))
		{
		  printf
		    ("Found matching pre-cracked hash %s with plaintext %s\n",
		     phash, pplain);
		  n->cracked = 1;

		  if (n->plaintext != NULL)
		    {
		      free (n->plaintext);
		      n->plaintext = NULL;
		    }

		  n->plaintext = (char *) calloc (1, strlen (pplain) + 1);

		  if (n->plaintext == NULL)
		    {
		      printf
			("Malloc error allocating space for plaintext\n");
		      return;
		    }
		  strncpy (n->plaintext, pplain, strlen (pplain));

		}
	      n = n->next;
	    }
	}
    }

  return;
}

/* compare a hash to see if it is correct */
/* we might need to expand this to make it support hash type variables */
int
compare_hash (char *hash, char *plain)
{
  return 0;
}


/* clears the hash list from memory */
void
clear_hashes ()
{
  struct pwhash *n, *x;

  printf ("Clearing hashes\n");

  n = headhash;

  while (n != NULL)
    {
      /* clear the hash itself, if there is one */
      if (n->plaintext != NULL)
	{
	  free (n->plaintext);
	}
      if (n->pass != NULL)
	{
	  free (n->pass);
	}
      x = n;
      n = n->next;
      free (x);			/* free it after we updated the next pointer, otherwise we lose it */
    }
/* set the head pointer to NULL */
  headhash = NULL;
  return;
}
