/* Load a file
 */

static const char rcsid[] =
  "$Id: loadfile.c,v 1.11 2007/07/17 20:52:26 bert Exp $";

#include "dnetj.h"
#include "server.h"
#include "client.h"

extern int regallow;
extern int highest_node;
extern unsigned short bindport;
extern int maxunits;
extern unsigned int latestunit;
extern int client;

extern char *config;
extern char *hashfile;
extern char *workinghash;
extern char *savefile;

extern unsigned int unitsize;
extern struct unit *headunit;

int
load_conf ()
{
  char readbuf[1024];
  FILE *cfg;

  cfg = fopen (config, "r");
  printf ("Reading config file: %s\n", config);

  if (cfg != NULL)
    {
      while (fgets (readbuf, sizeof (readbuf), cfg))
	{
	  if (readbuf[0] != '#')
	    {
	      prcfg (readbuf);
	    }
	}
    }
  else
    {
      printf ("Failed to open config file\n");
      exit (0);
    }
  printf ("Config file loaded\n");
  return 0;
}

#define LOADWORK_NORMAL 0
#define LOADWORK_RECFILE 1

/* this loads a work file */
int
loadworkfile (char *file)
{
  int mode = 0, remaining = 0;
  int units = 0;
  char readbuf[1024], rfbuf[1024];
  struct unit *wu;
  FILE *fd;

  fd = fopen (file, "r");

  if (fd == NULL)
    {
      printf ("Failed opening units file\n");
      return -1;
    }

/* read the first line and check for a valid header */
  fgets (readbuf, sizeof (readbuf), fd);
  if (readbuf[0] != '#')
    {
      printf ("Invalid file\n");
      return -1;
    }

  while (fgets (readbuf, sizeof (readbuf), fd))
    {
      if (strncmp (readbuf, "UNIT", 4) == 0)
	{			/* this line is a unit start tag */
/* we read until _EOF_ */
	  units++;
#ifdef EBUG
	  printf ("Start of unit: %s\n", readbuf);
#endif
	  mode = LOADWORK_RECFILE;	/* subsequent reads are the recfile */
	  remaining = sizeof (rfbuf);
	  memset (rfbuf, 0, sizeof (rfbuf));
	  wu = newunit ();
	  sscanf (readbuf, "UNIT:%u:%u:%u:%u:%u\n", &wu->id, &wu->size,
		  &wu->status, &wu->assigned, &wu->progress);
#ifdef EBUG
	  printf ("Unit read: %u:%u:%u:%u:%u\n", wu->id, wu->size, wu->status,
		  wu->assigned, wu->progress);
#endif
	  if (wu->id > latestunit)
	    latestunit = wu->id;

	}
      else if (strncmp (readbuf, "_EOF_", 4) == 0)
	{			/* this line is an EOF signal, which means we have the unit */
/* copy it to the linked list */
	  wu->recfile = (void *) calloc (1, strlen (rfbuf) + 1);
	  strncpy (wu->recfile, rfbuf, strlen (rfbuf));
	  addunit (wu);

/* return to normal mode */
	  mode = LOADWORK_NORMAL;
	}
      else if (mode == LOADWORK_RECFILE)
	{			/* this is part of the recfile, assuming mode is 1 */
	  strncat (rfbuf, readbuf, remaining);	/* concatenate it on the end of rfbuf, if theres space */
	  remaining = sizeof (rfbuf) - strlen (rfbuf) - 1;

	}
      else
	{			/* this should never happen */
	  printf ("BUG - we should never get here\n");
	  return -1;
	}
    }
  if (fd != NULL)
    {
      fclose (fd);
    }

  printf ("Loaded %d units\n", units);
  return 0;
}

int
load_hashes ()
{
  FILE *read;
  char readbuf[1024];
  char *ptr;
  unsigned int hashmode = 0;	/* hide username or not */
  unsigned int cuid = 0;
  struct pwhash *pw;

  if (hashfile == NULL)
    {
      printf ("Error, no hash file specified\n");
    }
  if (workinghash == NULL)
    {
/* set default */
      workinghash = (char *) calloc (1, strlen ("dnetj.runhash") + 1);
      sprintf (workinghash, "dnetj.runhash");
    }

  read = fopen (workinghash, "r");

  if (read == NULL)
    {				/* no working file, load real hash */
      read = fopen (hashfile, "r");
      hashmode = 1;
      if (read == NULL)
	{
	  if (client == 0)
	    {
	      printf ("Error, cannot open any hash file %s or %s\n",
		      workinghash, hashfile);
	      exit (0);
	    }
	  else
	    {
	      printf ("No saved hashes\n");
	      return -1;
	    }
	}
      printf ("Loading fresh hash file %s\n", hashfile);
    }
  else
    {
      printf ("Loading pre sanitised hash file %s\n", workinghash);
    }

/* here we load the hashfile... */
/* if hashmode is 0, we take as is, otherwise we hide the user */
  while (fgets (readbuf, sizeof (readbuf), read))
    {
/* cut out the username and hash */
      ptr = strtok (readbuf, ":");
      if (hashmode == 0)
	{			/* if loading sanitized hash files, do this, otherwise we increment */
	  cuid = atoi (ptr);
	}

      ptr = strtok (NULL, ":");
      if ((ptr != NULL) && (strlen (ptr) >= 10))
	{			/* hash is long enough */

	  pw = newhash ();
	  pw->id = cuid;
	  pw->pass = (char *) calloc (1, strlen (ptr) + 2);
	  snprintf (pw->pass, strlen (ptr) + 1, "%s", ptr);

	  addhash (pw);

	  if (hashmode == 1)
	    cuid++;
	}
    }
  recheck_hashes ();		/* this function checks for already cracked hashes */
  save_hashes ();		/* save out again */
  return 0;
}
