/* dnetj - maint.c - server - data maintenence procedures
 *
 */

static const char rcsid[] =
  "$Id: maint.c,v 1.21 2007/07/18 11:12:18 bert Exp $";

#include "dnetj.h"
#include "server.h"
#include "maint.h"
#include "sys/wait.h"

extern unsigned int loadunits;
extern unsigned int generating;
extern unsigned int unitbuffers;
extern char loadwork[];
extern struct unit *headunit;
extern int shuttingdown;
unsigned int last1 = 0;		/* last second */
unsigned int last10 = 0;	/* last 10 seconds */
unsigned int lastmin = 0;	/* last minute */
extern unsigned int genpid;
unsigned int unit_expire = 36000;	/* unit expiry in seconds, default 10 hours */

/* maintenence procedures, like expiring idle nodes */
void
maint_procs ()
{
  unsigned int now;

#ifdef EBUG
  printf ("Calling maintenence proc\n");
#endif

  now = time (NULL);

  if (last1 == 0)
    {
      printf ("Initializing time structures\n");
      last1 = now;
      last10 = now;
      lastmin = now;
    }
  if (shuttingdown == 1)
    {
/* create a proper shutdown procedure */
      close_all_sockets ();
      save_status_all ();
      exit (0);
    }
/* these get called every second */
  if ((last1 + 1) <= now)
    {
      last1 = now;
      check_fresh ();
      check_spares ();
      check_timeouts (0);
/* these get called every 10 seconds */
      if ((last10 + 10) <= now)
	{
	  last10 = now;
/* These get called every minute */
	  if ((lastmin + 60) <= now)
	    {
	      lastmin = now;
	      printf ("One minute since last save, saving\n");
	      save_status_all ();
	      check_expired_units (now);
	    }

	}
    }

  return;
}

/* check if there are enough spare units, if not fill our buffers */

void
check_spares ()
{
  int spares = 0;
  struct unit *wunit;

  wunit = headunit;

  while (wunit != NULL)
    {
      if (wunit->assigned == 0)
	{			/* unassigned unit */
	  spares++;
	}
      wunit = wunit->next;
    }
  if (spares < unitbuffers)
    {
#ifdef EBUG
      printf
	("We dont have enough spare units (want %d got %d), generating %d more\n",
	 unitbuffers, spares, unitbuffers - spares);
#endif
      genwork ((unitbuffers - spares), "tempfile");
    }
  else
    {
#ifdef EBUG
      printf ("We have enough spare units (want %d got %d)\n",
	      unitbuffers, spares);
#endif
    }
  return;
}

/* check if there are any freshly generated units */
void
check_fresh ()
{
  FILE *chk;

  if ((chk = fopen ("freshwork", "r")))
    {				/* there are new units to load */
      printf ("Loading new work units to cache\n");
      wait (NULL);
      if (loadwork != NULL)
	{
	  loadworkfile (loadwork);
	  unlink (loadwork);
	  generating = 0;
	  loadunits = 0;
	  fclose (chk);
	  unlink ("freshwork");
	  save_status_all ();
/* exit(0); */
	}
      else
	{
	  printf ("Error, filename to load work from is invalid\n");
	  loadunits = 0;
	}
    }

}

/* check expired nodes <now> */
/* checks for nodes which are assigned but which have expired */
void
check_expired_units (int now)
{
  unsigned int expired = 0;
  struct unit *u;
  struct node *n;

  if (unit_expire == 0)
    {				/* disabled */
      return;
    }

  u = headunit;

  while (u != NULL)
    {
      if (((u->progress + unit_expire) < now) && (u->assigned != 0))
	{
	  printf ("Unit %d has expired, assigned to %d at %d now is %d\n",
		  u->id, u->assigned, u->progress, now);
	  n = findnode (u->assigned);
	  if (n != NULL)
	    {
	      if (n->outstanding > 0)
		{
		  n->outstanding--;
		}
/* deassign the unit */
	      u->assigned = 0;
	    }
	  u->status = UNIT_BUF;
	  expired++;
	}
      u = u->next;
    }
  if (expired > 0)
    {
      printf ("Expired a total of %d units\n", expired);
    }
  return;
}
