/* dnetj - netcmd.c - server - network command processing
 *
 */
static const char rcsid[] =
  "$Id: netcmd.c,v 1.23 2007/07/17 20:52:27 bert Exp $";

#include "dnetj.h"
#include "server.h"

extern unsigned int regallow;
extern char sendbuf[];
extern struct pwhash *headhash;
extern unsigned int maxunits;
extern unsigned int unit_expire;

extern struct unit *headunit;

void
procbuf (char *buf, int s)
{
  char *cmd = NULL, *parms = NULL, *p = NULL;
  struct sockinf *si;

  si = findsockinf (s);

  if ((si == NULL) || (s < 0))
    {
      printf ("Something really bad happened\n");
      return;
    }

/* replacement for parsemsg */
  p = strchr (buf, '\n');
  if (p != NULL)
    p[0] = 0;

  p = strchr (buf, '\r');
  if (p != NULL)
    p[0] = 0;

  cmd = buf;

  p = strchr (buf, ' ');

  if (p != NULL)
    {
      p[0] = 0;
      parms = p + 1;
    }
/* end parsemsg replacement */
#ifdef EBUG
  printf ("DEBUG CMD: \"%s\"\n", cmd);
  printf ("DEBUG PARAM: \"%s\"\n", parms);
#endif
  if (si->regd == 0)
    {				/* unauthenticated commands */
      if (strncmp (cmd, "REGISTER", 8) == 0)
	{
	  register_client (si);
	  return;
	}
      else if (strncmp (cmd, "AUTH", 4) == 0)
	{
	  if (parms != NULL)
	    {
	      process_auth (parms, si);
	    }
	  return;
	}
    }
  else
    {
/* authenticated commands, get and submit units */
      if (strcmp (cmd, "GETHASH") == 0)	/* GETHASH - get current hashes */
	{
	  send_current_hashes (si);
	  return;
	}
      else if (strcmp (cmd, "GETUNIT") == 0)	/* GETUNIT - retrieve a unit */
	{
	  send_unit (si);
	  return;
	}
      else if (strcmp (cmd, "RSUNITS") == 0)	/* RSUNITS - resend allocated units */
	{
	  resend_units (si);
	  return;
	}
      else if (strcmp (cmd, "SUBMIT") == 0)	/* SUBMIT <number> */
	{
	  if (parms != NULL)
	    {
	      accept_submission (parms, si);
	    }
	  return;
	}
      else if (strcmp (cmd, "CRACKED") == 0)	/* CRACKED hashed:plaintext */
	{
	  if (parms != NULL)
	    {
	      accept_cracked (parms, si);
	    }
	  return;
	}

    }
  if (strcmp (cmd, "QUIT") == 0)
    {
      sprintf (sendbuf, "CTERM\r\n");
      write (si->sock, sendbuf, strlen (sendbuf));
      close (si->sock);
      killsockinf (si->sock);
      return;
    }
  else
    {
      sprintf (sendbuf, "INVCMD\r\n");
      write (si->sock, sendbuf, strlen (sendbuf));
      return;
    }

}

void
process_auth (char *parms, struct sockinf *si)
{
  char *ptr;
  unsigned int uid, now;
  struct node *n;

  if (parms == NULL)
    {
      printf ("Error, no authentication specified\n");
      sprintf (sendbuf, "AUTHFAIL\r\n");
      write (si->sock, sendbuf, strlen (sendbuf));
      return;
    }
  if (strlen (parms) < 1)
    {
      printf ("Error, no authentication specified\n");
      sprintf (sendbuf, "AUTHFAIL\r\n");
      write (si->sock, sendbuf, strlen (sendbuf));
      return;
    }

#ifdef EBUG
  printf ("AUTH: %s\n", parms);
#endif

  ptr = strtok (parms, " ");
  if (ptr == NULL)
    {
      sprintf (sendbuf, "AUTHFAIL\r\n");
      write (si->sock, sendbuf, strlen (sendbuf));
      return;
    }

  uid = atoi (ptr);

  ptr = strtok (NULL, " ");

  if (ptr == NULL)
    {
      sprintf (sendbuf, "AUTHFAIL\r\n");
      write (si->sock, sendbuf, strlen (sendbuf));
      return;
    }
  n = findnode (uid);

  if (n == NULL)
    {
      sprintf (sendbuf, "AUTHFAIL\r\n");
      write (si->sock, sendbuf, strlen (sendbuf));
      return;
    }
  if (!strncmp (n->pass, ptr, strlen (n->pass)))
    {
      sprintf (sendbuf, "AUTHOK\r\n");
      write (si->sock, sendbuf, strlen (sendbuf));
      now = time (NULL);
      si->thisnode = n;
      si->regd = 1;
      n->from = si->ip;
/* if this node has been disconnected long enough to have timed out, we reset its stats */
      if ((n->seen + unit_expire) < now)
	{
	  printf ("Expired unit %d is reconnecting\n", n->id);
	  n->registered = now;
	  n->completed = 0;
	}
      n->seen = now;
    }
  else
    {
      sprintf (sendbuf, "AUTHFAIL\r\n");
      write (si->sock, sendbuf, strlen (sendbuf));
    }
  return;
}

/* Accept a cached password from a node, requires auth
 * CRACKED hashed:plain
 * we write the file to john.pot and return an acknowledgement
 */
void
accept_cracked (char *parms, struct sockinf *si)
{
  struct pwhash *pw;
  FILE *pot;
  char *plain;

  if (parms == NULL)
    {
      snprintf (sendbuf, SENDBUF_SIZE, "HASHINV\r\n");
      write (si->sock, sendbuf, strlen (sendbuf));
      return;
    }

  printf ("calling accept_cracked\n");
  fflush (stdout);

  plain = strchr (parms, ':');

  if (plain == NULL)
    {
      snprintf (sendbuf, SENDBUF_SIZE, "HASHINV\r\n");
      write (si->sock, sendbuf, strlen (sendbuf));
      return;
    }

  plain[0] = 0;
  plain++;

  pot = fopen ("john.pot", "a");

/* write error */
  if (pot == NULL)
    {
      snprintf (sendbuf, SENDBUF_SIZE, "WRTERR\r\n");
      write (si->sock, sendbuf, strlen (sendbuf));
      return;
    }

/* compare the hash, see if it really is valid */
  if (!compare_hash (plain, parms))
    {

      printf ("Adding hash: %s to potfile with plaintext %s\n", parms, plain);
      fprintf (pot, "%s:%s\n", parms, plain);
      fclose (pot);

/* check for the hash in our linked list and mark it cradked */
      pw = headhash;
      while (pw != NULL)
	{
	  printf ("Comparing %s to %s\n", pw->pass, parms);
	  if (!strncmp (pw->pass, parms, strlen (pw->pass)))
	    {
	      printf ("Found hash %s in hashfile\n", pw->pass);
	      pw->cracked = 1;
	      if (pw->plaintext != NULL)
		{
		  free (pw->plaintext);
		  pw->plaintext = NULL;
		}

	      pw->plaintext = (char *) calloc (1, strlen (plain) + 1);
	      if (pw->plaintext == NULL)
		{
		  snprintf (sendbuf, SENDBUF_SIZE, "HASHERROR\r\n");
		  write (si->sock, sendbuf, strlen (sendbuf));
		  return;
		}
	      strncpy (pw->plaintext, plain, strlen (plain));

	    }
	  snprintf (sendbuf, SENDBUF_SIZE, "HASHACK\r\n");
	  write (si->sock, sendbuf, strlen (sendbuf));
	  pw = pw->next;
	}

    }
}

/* send_current_hashes - tells server to send current hashes to node
 * requires auth
 */

void
send_current_hashes (struct sockinf *si)
{
  int sent = 0;
  struct pwhash *n;
  n = headhash;
  printf ("Sending hashes to node %d:\n", si->thisnode->id);
  while (n != NULL)
    {
      if (n->cracked == 0)
	{
	  snprintf (sendbuf, SENDBUF_SIZE,
		    "ADDHASH %d:%s:::\r\n", n->id, n->pass);
#ifdef EBUG
	  printf ("DEBUG sendhash: %s", sendbuf);
#endif
	  write (si->sock, sendbuf, strlen (sendbuf));
	  sent++;
	}
      n = n->next;
    }
  if (sent > 0)
    {
      snprintf (sendbuf, SENDBUF_SIZE, "HASHEOF\r\n");
      write (si->sock, sendbuf, strlen (sendbuf));
    }
  else
    {
      snprintf (sendbuf, SENDBUF_SIZE, "NOHASH\r\n");
      write (si->sock, sendbuf, strlen (sendbuf));
    }
}

/* send_unit
 * called when client requests a unit to be sent to it
 */

void
send_unit (struct sockinf *si)
{
  char *ptr;
  struct unit *u;

/* check they dont already have their fill */

  if (si->thisnode->outstanding >= maxunits)
    {
      snprintf (sendbuf, SENDBUF_SIZE, "ENODEFULL\r\n");
      write (si->sock, sendbuf, strlen (sendbuf));
      return;
    }

/* get a pending unit */
  u = get_spare ();

  if (u == NULL)
    {
      printf ("We have no spare units to send to node %d\n",
	      si->thisnode->id);
      snprintf (sendbuf, SENDBUF_SIZE, "BUFERROR\r\n");
      write (si->sock, sendbuf, strlen (sendbuf));
      return;
    }

  printf ("Sending unit %d to node %d\n", u->id, si->thisnode->id);

  ptr = calloc (1, strlen (u->recfile) + 1);
  strncpy (ptr, u->recfile, strlen (u->recfile));
  encode_unit (ptr);
  snprintf (sendbuf, SENDBUF_SIZE, "UNIT %d %s\r\n", u->id, ptr);
  write (si->sock, sendbuf, strlen (sendbuf));
  free (ptr);
/* unit has been sent, update our structures */
  u->status = UNIT_PENDING;
  u->progress = time (NULL);
  u->assigned = si->thisnode->id;
  si->thisnode->outstanding++;
}

/* accept_submission
 * called when a client submits a completed block
 */
void
accept_submission (char *parms, struct sockinf *si)
{
  int unit;
  struct unit *u;

  unit = atoi (parms);

  u = findunit (unit);

/* this unit is not valid */
  if (u == NULL)
    {
      snprintf (sendbuf, SENDBUF_SIZE, "SUBMITACK %d\r\n", unit);
/*      snprintf (sendbuf, SENDBUF_SIZE, "EINVALIDUNIT\r\n"); */
      write (si->sock, sendbuf, strlen (sendbuf));
      return;
    }

/* this unit is assigned to a different node */
  if (u->assigned != si->thisnode->id)
    {
      snprintf (sendbuf, SENDBUF_SIZE, "SUBMITACK %d\r\n", u->id);
/*      snprintf (sendbuf, SENDBUF_SIZE, "EINVALIDNODE\r\n"); */
      write (si->sock, sendbuf, strlen (sendbuf));
      return;
    }

  snprintf (sendbuf, SENDBUF_SIZE, "SUBMITACK %d\r\n", u->id);
  write (si->sock, sendbuf, strlen (sendbuf));
/* decrement outstanding units */
  if (si->thisnode->outstanding > 0)
    {
      si->thisnode->outstanding--;
    }
/* increment completed nodes */
  si->thisnode->completed++;
  remunit (u);
  return;
}

void
resend_units (struct sockinf *si)
{
  struct unit *cu;
  char *ptr;

  cu = headunit;

  while (cu != NULL)
    {
      if (cu->assigned == si->thisnode->id)
	{
	  ptr = calloc (1, strlen (cu->recfile) + 1);
	  strncpy (ptr, cu->recfile, strlen (cu->recfile));
	  encode_unit (ptr);
	  printf ("Resending unit %d to node %d\n", cu->id, si->thisnode->id);
	  snprintf (sendbuf, SENDBUF_SIZE, "UNIT %d %s\r\n", cu->id, ptr);
	  write (si->sock, sendbuf, strlen (sendbuf));
	  free (ptr);

	}
      cu = cu->next;
    }
}
