/* DnetJ - Network commands for client
 */

static const char rcsid[] =
  "$Id: netcmdc.c,v 1.16 2007/07/18 11:16:55 bert Exp $";

#include "dnetj.h"
#include "server.h"
#include "client.h"

extern int regallow;
extern char sendbuf[];
extern struct pwhash *headhash;
extern int maxunits;
extern int read_finished;
int senthash = 0;
int ackhash = 0;
int downloading_hash = 0;
extern struct unit *headunit;
extern int myid;
extern char *mypass;

void
procbuf (char *buf, int s)
{
  char *cmd = NULL, *parms = NULL, *p = NULL;
  struct sockinf *si;

  si = findsockinf (s);

  if ((si == NULL) || (s < 0))
    {
      printf ("Something really bad happened\n");
      return;
    }

/* replacement for parsemsg */
  p = strchr (buf, '\n');
  if (p != NULL)
    p[0] = 0;

  p = strchr (buf, '\r');
  if (p != NULL)
    p[0] = 0;

  cmd = buf;

  p = strchr (buf, ' ');

  if (p != NULL)
    {
      p[0] = 0;
      parms = p + 1;
    }
/* end parsemsg replacement */
#ifdef EBUG
  printf ("DEBUG CMD: \"%s\"\n", cmd);
  printf ("DEBUG PARAM: \"%s\"\n", parms);
#endif

/* all commands are considered authed, since we initiated the connection */
  if (strncmp (cmd, "CTERM", 5) == 0)	/* CTERM - connection terminated */
    {
      printf ("Read finished\n");
      read_finished = 1;
      return;
    }
  else if (strncmp (cmd, "REGDISABLE", 10) == 0)	/* REGDISABLE - new node registration disabled */
    {
      printf ("Serious error - server does not allow registration\n");
      read_finished = 1;
      sleep (WAIT_TIME);
      return;
    }
  else if (strncmp (cmd, "READY", 5) == 0)	/* READY - Server is ready to rock */
    {
/* we have no user/pass, so we try to register */
      if (myid == 0)
	{
	  snprintf (sendbuf, SENDBUF_SIZE, "REGISTER\n");
	  write (s, sendbuf, strlen (sendbuf));
	}
      else
	{			/* try to authenticate */
	  snprintf (sendbuf, SENDBUF_SIZE, "AUTH %d %s\n", myid, mypass);
	  write (s, sendbuf, strlen (sendbuf));
	}
      return;
    }
  else if (strncmp (cmd, "YOURPASS", 8) == 0)	/* YOURPASS - registration, heres your pass */
    {
      if (mypass != NULL)
	{
	  snprintf (sendbuf, SENDBUF_SIZE, "ERR\n");
	  write (s, sendbuf, strlen (sendbuf));
	}
      if ((parms == NULL) | (strlen (parms) < 1))
	{
	  snprintf (sendbuf, SENDBUF_SIZE, "ERR\n");
	  write (s, sendbuf, strlen (sendbuf));
	  return;
	}
      mypass = (char *) calloc (1, strlen (parms) + 2);
      strncpy (mypass, parms, strlen (parms));
      printf ("Server sent us a new password, %s\n", mypass);
      save_auth ();
      return;
    }
  else if (strncmp (cmd, "YOURID", 6) == 0)	/* YOURID - registration, heres your id */
    {
      if (myid != 0)
	{
	  snprintf (sendbuf, SENDBUF_SIZE, "ERR\n");
	  write (s, sendbuf, strlen (sendbuf));
	}
      if ((parms == NULL) | (strlen (parms) < 1))
	{
	  snprintf (sendbuf, SENDBUF_SIZE, "ERR\n");
	  write (s, sendbuf, strlen (sendbuf));
	  return;
	}
      myid = atoi (parms);
      printf ("Server sent us a new ID, %d\n", myid);
      save_auth ();
      return;
    }
  else if (strncmp (cmd, "AUTHOK", 6) == 0)	/* AUTHOK - authentication succeeded */
    {
      dump_cracked (s);		/* dump our john.pot file if we have one */
      dump_completed (s);	/* dump our completed units if we have any */
      request_hashes (s);	/* request the hashes */
      request_pending (s);	/* request all pending units */
      request_unit (s);		/* request a unit */
      return;
    }
  else if (strncmp (cmd, "HASHACK", 7) == 0)	/* HASHACK - acknowlege receipt of a hash */
    {
      ackhash++;
      if (ackhash == senthash)
	{			/* all the hashes have been sent */
	  /* now we clear our john.pot file since the server got all our hashes */
	  printf ("All our hashes have been received\n");
	  unlink ("john.pot");
	}
      return;
    }
  else if (strncmp (cmd, "SUBMITACK", 9) == 0)	/* SUBMITACK %d - acknowledge receipt of a unit */
    {
      process_unit_ack (s, parms);
      return;
    }
  else if (strncmp (cmd, "AUTHFAIL", 8) == 0)	/* AUTHFAIL - authentication failed */
    {
      printf ("Server rejected our authentication, waiting\n");
      sleep (WAIT_TIME);
      return;
    }
  else if (strncmp (cmd, "ADDHASH", 7) == 0)	/* ADDHASH - add a new hash to our list */
    {
      add_new_hash (s, parms);
      return;
    }
  else if (strncmp (cmd, "HASHEOF", 7) == 0)	/* HASHEOF - end of hashes */
    {
      downloading_hash = 0;
      save_hashes ();
      return;
    }
  /* syntax UNIT 1 REC3!5!-keygen:all!-max:10000!/tmp/dis!--format=md5!1!0!10000!00002710!00000000!0!-1!a6d3ae70!51!0!8!1!0!1!0!1!0!0!0!!!! */
  else if (strncmp (cmd, "UNIT", 4) == 0)	/* UNIT - accept a unit */
    {
      receive_unit (s, parms, MODE_RECVNEW);
      return;
    }
  else if (strncmp (cmd, "RSUNIT", 6) == 0)	/* RSUNIT - accept a resent unit */
    {
      receive_unit (s, parms, MODE_RESEND);
      return;
    }
  else if (strncmp (cmd, "BUFERROR", 4) == 0)	/* server is out of units */
    {
      printf
	("Server has no spare nodes, waiting %d seconds before retrying\n",
	 WAIT_TIME);
      sleep (WAIT_TIME);
      snprintf (sendbuf, SENDBUF_SIZE, "GETUNIT\n");
      write (s, sendbuf, strlen (sendbuf));
      return;
    }
  else if (strncmp (cmd, "ENODEFULL", 9) == 0)	/* ENODEFULL - we have more units than we should */
    {
/* server will only send us x units, set maxunits to x */
      read_finished = 1;
      snprintf (sendbuf, SENDBUF_SIZE, "QUIT\n");
      write (s, sendbuf, strlen (sendbuf));
      killsockinf (s);
      close (s);
      return;
    }

  return;
}

/* increment senthash */
void
dump_cracked (int s)
{
  char readbuf[1024], *p = NULL;
  FILE *fil;

  senthash = 0;
  ackhash = 0;

/* read john.pot */

  fil = fopen ("john.pot", "r");

  if (fil == NULL)
    {				/* john.pot is empty */
      return;
    }

  while (fgets (readbuf, sizeof (readbuf), fil))
    {

      p = strchr (readbuf, '\n');
      if (p != NULL)
	p[0] = 0;

      p = strchr (readbuf, '\r');
      if (p != NULL)
	p[0] = 0;
      printf ("Sending cracked pass: %s\n", readbuf);

      snprintf (sendbuf, SENDBUF_SIZE, "CRACKED %s\n", readbuf);
      write (s, sendbuf, strlen (sendbuf));
      senthash++;
    }

  if (fil != NULL)
    {
      fclose (fil);
    }
  return;
}

/* iterate through our completed work units */
/* send completed ones, then remove from linked list */
/* finally save the work units file */
void
dump_completed (int s)
{
  int x = 0;
  struct unit *currunit = headunit;
  struct unit *tmp = NULL;

  printf ("Sending completed units to server\n");
  while (currunit != NULL)
    {
      if (currunit->status == UNIT_COMPLETE)
	{
	  x++;
	  snprintf (sendbuf, SENDBUF_SIZE, "SUBMIT %d\n", currunit->id);
	  write (s, sendbuf, strlen (sendbuf));
	  tmp = currunit;
/* we wait for the ACK before we remove */
	}
      currunit = currunit->next;
    }
  printf ("DEBUG: dump_completed() %d completed units to upload\n", x);

}

/* request pending unit */
void
request_pending (int s)
{
  snprintf (sendbuf, SENDBUF_SIZE, "RSUNITS\n");
  write (s, sendbuf, strlen (sendbuf));
}

/* just request a single unit */
void
request_unit (int s)
{
  snprintf (sendbuf, SENDBUF_SIZE, "GETUNIT\n");
  write (s, sendbuf, strlen (sendbuf));
}

/* request the hashes */
void
request_hashes (int s)
{
  snprintf (sendbuf, SENDBUF_SIZE, "GETHASH\n");
  write (s, sendbuf, strlen (sendbuf));
}

/* add a new hash to the linked list */
/* check status of downloading_hash */
/* parms contains: ADDHASH 0:$1$ET9dbA0H$.IjmGsKE5lYJwJeJxgGAl0::: */
void
add_new_hash (int s, char *parms)
{
  int cuid;
  char *haptr, *idptr;
  struct pwhash *pw;

  if (downloading_hash == 0)
    {				/* we arent yet downloading hashes, clear the linked lists */
      printf ("Clearing existing hashes\n");
      clear_hashes ();
    }

/* we are downloading now, so we set this to 1 */
/* when we get a HASHEOF, this goes back to 0 */
  downloading_hash = 1;

  idptr = strtok (parms, ":");	/* find the first parameter, the id */
  haptr = strtok (NULL, ":");	/* the second parameter, the hash */

  cuid = atoi (idptr);

  pw = newhash ();

  pw->id = cuid;
  pw->pass = (char *) calloc (1, strlen (haptr) + 2);
  snprintf (pw->pass, strlen (haptr) + 1, "%s", haptr);

  addhash (pw);
  printf ("Added hash index %d, string %s\n", pw->id, pw->pass);
  return;
}

/* receive a unit, convert it, add it to linked list, save */
/*
UNIT 19 REC3!5!-keygen:all!-max:10000!/tmp/dis!--format=md5!1!0!10000!00002710!00000000!0!-1!a6d3ae70!51!0!8!1!0!1!0!1!0!0!0!!!
*/
void
receive_unit (int s, char *parms, int mode)
{
  int uid;
  char *ptri, *ptrh;
  struct unit *wunit;

  ptri = strtok (parms, " ");	/* pull out the ID */
  if (ptri == NULL)
    return;
  ptrh = strtok (NULL, " ");	/* pull out the unit */
  if (ptrh == NULL)
    return;

  uid = atoi (ptri);

/* printf("DEBUG: ID %d String: %s\n", uid, ptrh); */
/* now we have the unit, we load it into our linked list */

/* unpack the unit from the transport stream */
  decode_unit (ptrh);

  wunit = newunit ();
  wunit->id = uid;
  wunit->size = 0;
  wunit->status = UNIT_SPARE;
  wunit->assigned = 0;
  wunit->progress = 0;

  wunit->recfile = (void *) calloc (1, strlen (ptrh) + 1);
  strncpy (wunit->recfile, ptrh, strlen (ptrh));

  addunit (wunit);		/* add the unit */
  printf ("Added unit %d to buffers\n", wunit->id);

/* save the unit */
/* yes this is inefficient */
  save_units ();

/* logic to ask for more units */
  if (mode == MODE_RECVNEW)
    {
      if (count_pending () < maxunits)
	{			/* We want more units */
	  printf ("Requesting additional units\n");
	  request_unit (s);
	}
      else
	{
	  read_finished = 1;	/* were finished */
	}
    }
}

void
process_unit_ack (int s, char *parms)
{
  int x;
  struct unit *unit;

  if (parms == NULL)
    return;

  x = atoi (parms);
  unit = findunit (x);

  remunit (unit);


}
