/* dnetj - nodes.c - server - node list manipulation functions
 *
 */

static const char rcsid[] =
  "$Id: nodes.c,v 1.8 2007/07/17 20:52:27 bert Exp $";

#include "dnetj.h"
#include "server.h"

struct node *headnode = NULL;
unsigned int highest_node = 0;
extern int regallow;

/* add a node to the list */
void
addnode (struct node *si)
{
  struct node *s = headnode, *old = NULL;
  si->next = NULL;
  while (s != NULL)
    {
      old = s;
      s = s->next;
    }
  if (old != NULL)
    {
      old->next = si;
    }
  else
    {
      headnode = si;
    }
/* update highest node */
  if (si->id > highest_node)
    highest_node = si->id;
}

/* shitcan a node */
int
remnode (struct node *s)
{
  struct node *x, *old;
  x = headnode;
  old = NULL;

  while ((x) && (x != s))
    {
      old = x;
      x = x->next;
    }

  if (old == NULL)
    headnode = x->next;
  else
    old->next = x->next;

  free (x);
  return 1;
}

struct node *
newnode ()
{
  struct node *si;
  si = (struct node *) calloc (1, sizeof (struct node));
  return si;
}

struct node *
findnode (int s)
{
  struct node *currnode;

  currnode = headnode;

  while (currnode != NULL)
    {
      if (currnode->id == s)
	{
	  return currnode;
	}
      currnode = currnode->next;
    }
  return NULL;
}

int
load_nodes ()
{
  char readbuf[1024];
  struct node *nnode;
  FILE *nf;


  nf = fopen (NODEFILE, "r");

  if (nf == NULL)
    {
      printf ("No user file, going into register mode\n");
      regallow = 1;
      return -1;
    }

  while (fgets (readbuf, sizeof (readbuf), nf))
    {

      if (readbuf[0] != '#')
	{
	  nnode = newnode ();
	  sscanf (readbuf, "%u:%u:%u:%u:%u:%u:%s\n", &nnode->id,
		  &nnode->seen, &nnode->registered, &nnode->from,
		  &nnode->outstanding, &nnode->completed, nnode->pass);

	  if (nnode->id > highest_node)
	    highest_node = nnode->id;

	  addnode (nnode);
	}
    }
  return 0;
}

void
save_nodes ()
{
  struct node *n;
  FILE *nodefile;

  nodefile = fopen (NODEFILE, "w");
  if (nodefile == NULL)
    {
      printf ("Error - cannot open nodes file\n");
      return;
    }

  n = headnode;

  printf ("Saving nodes\n");
  fprintf (nodefile, "# nodes 1 - dnetj nodefile\n");

  while (n != NULL)
    {
      fprintf (nodefile, "%u:%u:%u:%u:%u:%u:%s\n", n->id, n->seen,
	       n->registered, n->from, n->outstanding, n->completed, n->pass);
      n = n->next;
    }
  fclose (nodefile);
  printf ("Nodes saved\n");
}
