/* dnetj - register.c - server - node registration functions
 *
 */

static const char rcsid[] =
  "$Id: register.c,v 1.7 2007/07/17 20:52:27 bert Exp $";

#include "dnetj.h"
#include "server.h"

extern int regallow;
extern char sendbuf[];
extern int highest_node;

/* generate a random string */
void
randstr (char *dst, int len)
{
  memset (dst, 0, len);
  snprintf (dst, len, "%c%c%c%c%c%c%c%c%c%c%c%c%c", rand () % 52 + 65,
	    rand () % 52 + 65, rand () % 52 + 65, rand () % 52 + 65,
	    rand () % 52 + 65, rand () % 52 + 65, rand () % 52 + 65,
	    rand () % 52 + 65, rand () % 52 + 65, rand () % 52 + 65,
	    rand () % 52 + 65, rand () % 52 + 65, rand () % 52 + 65);
  return;
}

/* register a client */
void
register_client (struct sockinf *s)
{
  struct node *new;

  if (regallow == 0)
    {
      sprintf (sendbuf, "REGDISABLE\r\n");
      write (s->sock, sendbuf, strlen (sendbuf));
      return;
    }

  printf ("Client attempting to register from %s\n", rlookup (s->ip));

  new = newnode ();

  highest_node++;
  new->id = highest_node;
  randstr (new->pass, PASSLEN);
  new->registered = time (NULL);
  new->seen = new->registered;
  new->from = s->ip;

  snprintf (sendbuf, SENDBUF_SIZE, "REGOK\r\n");
  write (s->sock, sendbuf, strlen (sendbuf));

  snprintf (sendbuf, SENDBUF_SIZE, "YOURID %d\r\n", new->id);
  write (s->sock, sendbuf, strlen (sendbuf));

  snprintf (sendbuf, SENDBUF_SIZE, "YOURPASS %s\r\n", new->pass);
  write (s->sock, sendbuf, strlen (sendbuf));

  snprintf (sendbuf, SENDBUF_SIZE, "AUTHOK\r\n");
  write (s->sock, sendbuf, strlen (sendbuf));


/* add to list */
  addnode (new);
/* flag the socket as registered */
  s->regd = 1;
  s->thisnode = new;
  printf ("Client registered with ID: %d and pass: %s\n", new->id, new->pass);

  return;
}
