/*
 *	Dnetj server
 * (C) 2007 john@ev6.net
 *
 */

static const char rcsid[] =
  "$Id: server.c,v 1.19 2007/07/20 08:58:12 bert Exp $";

#define _FORTIFY_SOURCE 2

#include "dnetj.h"
#include "server.h"

/* global vars */
unsigned int genpid = 0;	/* pid of work generation thread */
unsigned int protover = 1;	/* default protocol version */
int highest_fd;
struct sockinf *headsockinf = NULL;
int sc[2048];
char readbuf[4096];
char prbuf[4096];
int MAXFD;
int regallow = 0;
unsigned short bindport = DEFPORT;
unsigned int shuttingdown = 0;
char *config = NULL;		/* config file name */
char loadwork[64];		/* a filename to load work from */
unsigned int latestunit = 0;	/* The last unit generated */
char *hashfile = NULL;		/* the hash file */
char *workinghash = NULL;	/* the work in progress hash */
unsigned int unitsize = DEFUNITSIZE;	/* default size of a work unit */
unsigned int unitbuffers = UNIT_BUFFER;	/* default number of units to buffer */
char *savefile;			/* where to save our progress */
int maxunits = 5;		/* maximum units per node */
unsigned int client = 0;	/* we are not a client */
unsigned int startuptime=0;

void
usage ()
{
  printf ("Wrong usage\n");
}

int
loadfile ()
{
  load_conf ();
  load_hashes ();
  load_nodes ();
  loadworkfile (savefile);
  return 0;
}

void
mainloop ()
{
  fd_set read_set, write_set;
  int res, i, nfds;
  signed int x = 0;
  char *tptr, *ttptr;
  struct sockinf *currsockinf, *sitemp = NULL;
  struct timeval tv;

  startuptime=time(NULL);

  while (1)
    {
/* one line per iteration */
      for (res = 0;;)
	{
	  FD_ZERO (&read_set);
	  FD_ZERO (&write_set);
	  FD_SET (STDIN, &read_set);

	  currsockinf = headsockinf;

	  highest_fd = 0;
	  while (currsockinf != NULL)
	    {
	      FD_SET (currsockinf->sock, &read_set);
	      FD_SET (currsockinf->sock, &write_set);
	      if (highest_fd < currsockinf->sock)
		highest_fd = currsockinf->sock;

	      currsockinf = currsockinf->next;
	    }

	  tv.tv_sec = 5;
	  tv.tv_usec = 0;
	  nfds = select ((highest_fd + 1), &read_set, &write_set, NULL, &tv);
	  if (nfds >= 0)
	    break;
	  perror ("select");
	  fflush (stdout);
	  sleep (1);
	}
      currsockinf = headsockinf;

      while (currsockinf != NULL)
	{
	  i = currsockinf->sock;
	  if (i > 0)
	    {
	      if (FD_ISSET (i, &read_set) && (i != STDIN))
		{
		  FD_CLR (i, &read_set);
		  memset (readbuf, 0, sizeof (readbuf));
#ifdef EBUG
		  printf ("Reading from sock: %d\n", currsockinf->sock);
#endif
		  if (currsockinf->mode == MODE_LISTEN)
		    {
		      process_connect (currsockinf->sock);
		    }
		  else
		    {
		      x = read (i, readbuf, sizeof (readbuf) - 1);
		      if (x <= 0)
			{
			  close (i);
			  printf ("dead sock: %d\n", i);
/* destroy the struct sockinf */
/* set a temporary one, clear it later */
			  sitemp = currsockinf;
			  sc[i] = -1;
			}
		      else
			{
/* cheesy parsing */
/* what if we get a partial line.... */
#ifdef EBUG
			  printf
			    ("DEBUG: read %d chars, readbuf is %d at %p\n", x,
			     sizeof (readbuf), readbuf);
			  printf ("DEBUG SOCK %d RECV: %s|||END\n", i,
				  readbuf);
#endif
			  currsockinf->last = time (NULL);
			  tptr = NULL;
			  ttptr = readbuf;
			  tptr = strchr (readbuf, '\n');	/* find the \n */
			  while (tptr != NULL)
			    {
			      *tptr = 0;	/* zero out the \n */
#ifdef EBUG
			      printf ("DEBUG LINE SOCK %d: %s\n", i, ttptr);
#endif
			      snprintf (prbuf, sizeof (prbuf), "%s", ttptr);
			      procbuf (prbuf, i);
			      tptr++;
			      ttptr = tptr;	/* new is old */
			      tptr = strchr (ttptr, '\n');	/* next */
			    }
			}
		    }
		}
	    }
	  else
	    {
	      printf ("Warning: invalid socket structure\n");
	    }
/* write was here */
	  currsockinf = currsockinf->next;
	  if (sitemp != NULL)
	    {
	      killsockinf (sitemp->sock);
	      sitemp = NULL;
	    }
	}
/* here we read from STDIN */
      if (FD_ISSET (STDIN, &read_set))
	{
#ifdef EBUG
	  printf ("Select: reading from STDIN\n");
#endif
	  FD_CLR (STDIN, &read_set);
	  memset (readbuf, 0, sizeof (readbuf));
	  if (read (STDIN, readbuf, sizeof (readbuf)) <= 0)
	    {
	      printf ("Eww! Read error from stdin! Exiting!\n");
	      exit (1);
	    }
	  procstdin (readbuf);
	}
/* here we do the regular maintenence */
      maint_procs ();
    }
}


int
main (int argc, char *argv[])
{
  unsigned int sock;
/* for readfile parsing */
  FILE *fil;

/* NULL the fresh linked lists */
  headsockinf = NULL;

  srand (time (NULL));
  srandom (time (NULL));

  banner ();

/* open the config file */
  fil = fopen (argv[1], "r");

  if (fil == NULL)
    {
      usage ();
      exit (0);
    }
  fclose (fil);

  config = (void *) calloc (1, strlen (argv[1]) + 1);

  strncpy (config, argv[1], strlen (argv[1]));

/* load the data files */
  loadfile ();

  signal (SIGTERM, handle_sigterm);
  signal (SIGINT, handle_sigterm);
  signal (SIGPIPE, handle_sigpipe);

/* create the listen socket */
  sock = openlisten (bindport);
  printf ("Listening on port %d, socket %d\n", bindport, sock);

  highest_fd = sock;

  printf ("Entering main loop\n");
  mainloop ();
  return 0;
}
