static const char rcsid[] =
  "$Id: socket.c,v 1.16 2007/07/18 22:17:19 bert Exp $";

#include "dnetj.h"

extern struct sockinf *headsockinf;
extern fd_set *read_set;
char sendbuf[SENDBUF_SIZE];
extern unsigned int protover;
unsigned int socktimeout = TIMEOUT_DEFAULT;

/* check for timed out sockets */
void
check_timeouts (int sock)
{
  unsigned int now, s;
  struct sockinf *si, *tmp;

  now = time (NULL);

  if (sock == 0)
    {				/* do all sockets */
      si = headsockinf;

      while (si != NULL)
	{
	  tmp = NULL;
	  if (si->mode != MODE_LISTEN)
	    {
	      if ((si->last + socktimeout) < now)
		{		/* timed out */
		  tmp = si;
		}
	    }
	  si = si->next;
	  if (tmp != NULL)
	    {
	      printf ("Socket %d timed out read after %d seconds\n",
		      tmp->sock, socktimeout);
	      s = tmp->sock;
	      killsockinf (tmp->sock);
	      close (s);
	      tmp = NULL;
	    }

	}
    }
  else
    {				/* do the specified socket */
      si = findsockinf (sock);
      if (si != NULL)
	{
	  if ((si->last + socktimeout) < now)
	    {
	      printf ("Socket %d timed out read after %d seconds\n", si->sock,
		      socktimeout);
	      killsockinf (si->sock);
	      close (si->sock);

	    }

	}

    }
}

int
process_connect (unsigned int sock)
{
  unsigned int addrlen, newsock;
  struct sockinf *s;

  struct sockaddr_in from;
  addrlen = sizeof (struct sockaddr);

  newsock = accept (sock, (struct sockaddr *) &from, &addrlen);

  if (newsock < 0)
    return -1;


  s = newsockinf ();
  s->sock = newsock;
  s->ip = from.sin_addr.s_addr;
  s->mode = MODE_WAITCMD;
  s->regd = 0;			/* not registered/authed yet */
  s->last = time (NULL);	/* last seen data */
  addsockinf (s);
/* print banner here, so we can differentiate proper versions on the client */
  snprintf (sendbuf, sizeof (sendbuf),
	    "dnetj Server Version %s proto %d %s\nREADY\n", DNETJ_VER,
	    protover, DNETJ_DEVDATE);
  write (s->sock, sendbuf, strlen (sendbuf));
  printf ("Accepted connection %d from %s\n", s->sock, nlookup (s->ip));

  return 0;
}


void
addsockinf (struct sockinf *si)
{
  struct sockinf *s = headsockinf, *old = NULL;
  si->next = NULL;
  while (s != NULL)
    {
      old = s;
      s = s->next;
    }
  if (old != NULL)
    {
      old->next = si;
    }
  else
    {
      headsockinf = si;
    }
}

int
killsockinf (int s)
{
  struct sockinf *x, *old;

if (headsockinf==NULL) {
return 0;
}

  x = headsockinf;
  old = NULL;

  while (x != NULL && (x->sock) && (x->sock != s))
    {
      old = x;
      x = x->next;
    }
  if (old == NULL)
    headsockinf = x->next;
  else
    old->next = x->next;
  free (x);
  return 1;
}

struct sockinf *
newsockinf ()
{
  struct sockinf *si;
  si = (struct sockinf *) calloc (1, sizeof (struct sockinf));
  return si;
}

struct sockinf *
findsockinf (int s)
{
  struct sockinf *currsockinf;

  currsockinf = headsockinf;

  while (currsockinf != NULL)
    {
      if (currsockinf->sock == s)
	{
	  return currsockinf;
	}
      currsockinf = currsockinf->next;
    }
  return NULL;
}

int
openlisten (unsigned short port)
{
  unsigned int lsock, yes = 1;
  struct sockaddr_in laddr;
  struct sockinf *newsi;

  memset (&laddr, 0, sizeof (struct sockaddr_in));

  laddr.sin_port = htons (port);
  if ((lsock = socket (PF_INET, SOCK_STREAM, IPPROTO_TCP)) == -1)
    {
      perror ("socket");
      return 20;
    }

  setsockopt (lsock, SOL_SOCKET, SO_REUSEADDR, &yes, sizeof (int));

  laddr.sin_family = AF_INET;
  laddr.sin_addr.s_addr = htonl (0);
  if (bind (lsock, (struct sockaddr *) &laddr, sizeof (laddr)))
    {
      perror ("bind");
      exit (20);
    }
  if (listen (lsock, 1))
    {
      perror ("listen");
      return 20;
    }

  newsi = newsockinf ();
  newsi->sock = lsock;
  newsi->mode = MODE_LISTEN;

  addsockinf (newsi);

  return lsock;
}

char *
rlookup (unsigned int ip)
{
  static char hostname[256];
  struct hostent *host;
  struct in_addr ami;
  struct sockaddr_in addr;
  char scheisse[100];

  addr.sin_addr.s_addr = ip;
  host =
    gethostbyaddr ((char *) &addr.sin_addr, sizeof (addr.sin_addr), AF_INET);

  if (host == NULL)
    {
      ami.s_addr = ip;
      strcpy (scheisse, (char *) inet_ntoa (ami));
      snprintf (hostname, 256, "%s", scheisse);
    }
  else
    {
      snprintf (hostname, sizeof (hostname), "%s", host->h_name);
    }
  return hostname;
}

char *
nlookup (unsigned int ip)
{
  static char hostname[256];
  struct in_addr ami;
  struct sockaddr_in addr;
  char scheisse[100];

  addr.sin_addr.s_addr = ip;

  ami.s_addr = ip;
  strcpy (scheisse, (char *) inet_ntoa (ami));
  snprintf (hostname, 256, "%s", scheisse);

  return hostname;
}

void
close_all_sockets ()
{
  struct sockinf *si;

  si = headsockinf;

  printf ("Closing sockets\n");
  while (si != NULL)
    {

#ifdef EBUG
      printf ("Socket: %d Addr %s Type: %d Next %p\n", si->sock,
	      rlookup (si->ip), si->mode, (void *) si->next);
#endif
      close (si->sock);
      si = si->next;
    }

  printf ("Sockets closed\n");


}
