/* Load a file
 */

static const char rcsid[] =
  "$Id: srvconf.c,v 1.7 2007/07/17 20:52:27 bert Exp $";

#include "dnetj.h"
#include "server.h"
#include "client.h"

extern unsigned int regallow;
extern unsigned int highest_node;
extern unsigned short bindport;
extern unsigned int maxunits;
extern unsigned int latestunit;
extern unsigned int unit_expire;
extern unsigned int client;
extern unsigned int unitbuffers;
extern unsigned int socktimeout;
extern char *config;
extern char *hashfile;
extern char *workinghash;
extern char *savefile;

extern unsigned int unitsize;
extern struct unit *headunit;

/* process a server config file line */
void
prcfg (buf)
     char buf[4096];
{
  char *cmd = NULL, *parms = NULL, *p = NULL;

  p = strchr (buf, '\n');
  if (p != NULL)
    p[0] = 0;

  p = strchr (buf, '\r');
  if (p != NULL)
    p[0] = 0;

  cmd = buf;

  p = strchr (buf, ' ');

  if (p != NULL)
    {
      p[0] = 0;
      parms = p + 1;
    }


  if (!strncasecmp (cmd, "PORT", 4))
    {
      bindport = atoi (parms);
      printf ("Listening on port %d\n", bindport);
      return;
    }
  else if (!strncasecmp (cmd, "PWD", 3))
    {
      hashfile = (char *) calloc (1, strlen (parms) + 2);
      snprintf (hashfile, strlen (parms) + 1, "%s", parms);
      printf ("Using hash file %s\n", hashfile);
      return;
    }
  else if (!strncasecmp (cmd, "WORKHASH", 8))
    {
      workinghash = (char *) calloc (1, strlen (parms) + 2);
      snprintf (workinghash, strlen (parms) + 1, "%s", parms);
      printf ("Using working hash file %s\n", workinghash);
      return;
    }
  else if (!strncasecmp (cmd, "SAVEFILE", 8))
    {
      savefile = (char *) calloc (1, strlen (parms) + 2);
      snprintf (savefile, strlen (parms) + 1, "%s", parms);
      printf ("Using work unit save file %s\n", savefile);
      return;
    }
  else if (!strncasecmp (cmd, "UNITSIZE", 8))	/* this will get overwritten later when we read units */
    {
      unitsize = atoi (parms);
      printf ("Setting work unit size to %d\n", unitsize);
      return;
    }
  else if (!strncasecmp (cmd, "EXPIRE", 6))	/* number of seconds before expiring an assigned unit */
    {
      unit_expire = atoi (parms);
      printf ("Setting unit expiry time to to %d\n", unit_expire);
      return;
    }
  else if (!strncasecmp (cmd, "BUFFERS", 7))
    {
      unitbuffers = atoi (parms);
      printf ("Buffering %d units\n", unitbuffers);
      return;
    }
  else if (!strncasecmp (cmd, "TIMEOUT", 7))
    {
      socktimeout = atoi (parms);
      printf ("Setting socket timeout to %d seconds\n", socktimeout);
      return;
    }
  else if (!strncasecmp (cmd, "MAXUNITS", 8))
    {
      maxunits = atoi (parms);
      printf ("Setting maximum units per node to %d\n", maxunits);
      return;
    }
}
