/* Status reporting functions */

static const char rcsid[] =
  "$Id: status.c,v 1.12 2007/08/02 08:48:26 bert Exp $";

#include "dnetj.h"
#include "server.h"

extern struct node *headnode;
extern struct sockinf *headsockinf;
extern struct pwhash *headhash;
extern int regallow;
extern unsigned short bindport;
extern struct unit *headunit;
extern unsigned int unitsize;
extern unsigned int startuptime;

void
general_status_report ()
{
  printf ("Registration status: %d\n", regallow);
  printf ("Listening on port %d\n", bindport);

}

void uptime (int current)
{
char timebuf[64];
unsigned int uptime, hr, min;


uptime = current - startuptime;

 memset (timebuf, 0, sizeof (timebuf));

  if (uptime > 86400)
    {
      /* days */  
      snprintf (timebuf, sizeof(timebuf), "%d day", (int) (uptime / 86400)); /* leave space for s, */
      if ((int) (uptime / 86400) >= 2)
        strcat (timebuf, "s");

      strcat (timebuf, ",");
      uptime -= (((int) (uptime / 86400)) * 86400);
    }

  hr = (time_t) ((int) uptime / 3600);
  uptime -= (hr * 3600);

  min = (time_t) ((int) uptime / 60);
  uptime -= (min * 60);

  printf ("Uptime: %s %02d:%02d:%02d\n", timebuf,  hr, min, uptime);

return;

}

void
node_status_report ()
{
  unsigned int now, rate = 0;
  struct node *n;
  uint64_t crypts=0;

  now = time (NULL);
  n = headnode;

  printf ("Node status:\n");
  while (n != NULL)
    {
      crypts = n->completed * unitsize;

      printf
	("Node: %d, pass %s, last seen %d seconds ago from %s(%s) with %d outstanding and %d completed units in %d seconds %d c/s\n",
	 n->id, n->pass, (now - n->seen), nlookup (n->from),
	 rlookup (n->from), n->outstanding, n->completed,
	 (now - n->registered),
	 (unsigned int) (crypts / (now - n->registered)));
      rate = rate + ((n->completed * unitsize) / (now - n->registered));
      n = n->next;
    }
  printf ("Total rate: %d c/s\n", rate);
  printf ("End of node status\n");
  uptime(now);
}

void
hash_status_report ()
{
  struct pwhash *n;

  n = headhash;

  printf ("Password hash status:\n");
  while (n != NULL)
    {
      if (n->plaintext != NULL)
	{

	  printf ("Userid: %d, Hash %s, cracked: %d, plaintext %s\n",
		  n->id, n->pass, n->cracked, n->plaintext);
	}
      else
	{
	  printf ("Userid: %d, Hash %s, cracked: %d\n",
		  n->id, n->pass, n->cracked);
	}
      n = n->next;
    }

  printf ("End of hash status\n");
}

void
socket_status_report ()
{
  struct sockinf *si;

  si = headsockinf;

  printf ("Socket status:\n");
  while (si != NULL)
    {

      printf ("Socket: %d Addr %s Type: %d Next %p\n", si->sock,
	      rlookup (si->ip), si->mode, (void *) si->next);
      si = si->next;
    }

  printf ("End of socket status\n");
}

/* find all assigned units					*/
/* print the node theyre assigned to, time they were assigned	*/
void
unit_status_report ()
{
  char xtime[32], *ptr;
  time_t tmx;
  struct unit *cu = headunit;
  struct node *n;

  while (cu != NULL)
    {
      if (cu->status == UNIT_PENDING)
	{
/* print the status */
	  n = findnode (cu->assigned);
	  if (n != NULL)
	    {
	      tmx = cu->progress;
	      strncpy (xtime, ctime (&tmx), sizeof (xtime) - 1);
	      xtime[sizeof (xtime)] = 0;
	      ptr = strchr (xtime, '\n');
	      if (ptr != NULL)
		ptr[0] = 0;

	      printf ("Pending %d, assigned to %d from %s at [%s]\n", cu->id,
		      cu->assigned, rlookup (n->from), xtime);
	    }
	  else
	    {
	      printf ("Error - node is invalid, this shouldnt happen\n");
	    }
	}
      cu = cu->next;
    }

}
