/* user specified commands */

static const char rcsid[] =
  "$Id: uicmds.c,v 1.10 2007/07/26 11:42:14 bert Exp $";

#include "dnetj.h"
#include "server.h"

extern struct sockinf *headsockinf;
extern int regallow;
extern unsigned int generating;
extern struct unit *headunit;
extern struct node *headnode;

/* stdin commands here */
void
procstdin (char *buf)
{
  char *cmd = NULL, *parms = NULL, *p = NULL;

  p = strchr (buf, '\n');
  if (p != NULL)
    p[0] = 0;

  p = strchr (buf, '\r');
  if (p != NULL)
    p[0] = 0;

  cmd = buf;

  p = strchr (buf, ' ');

  if (p != NULL)
    {
      p[0] = 0;
      parms = p + 1;
    }

  if (!strncasecmp (cmd, "STAT", 4))
    {				/* show status */
      general_status_report ();
      socket_status_report ();
      unit_status_report ();
      node_status_report ();
      hash_status_report ();
    }
  else if (!strncasecmp (cmd, "NODES", 5))
    {				/* show node status */
      node_status_report ();
    }
  else if (!strncasecmp (cmd, "HASHES", 6))
    {				/* show hash status */
      hash_status_report ();
    }
  else if (!strncasecmp (cmd, "REGISTER", 8))
    {
      cmd_register (parms);
    }
  else if (!strncasecmp (cmd, "UPTIME", 6))
    {
      uptime(time(NULL));
    }
  else if (!strncasecmp (cmd, "KILLNODE", 8))
    {
      cmd_killnode (parms);
    }
  else if (!strncasecmp (cmd, "RESETNODE", 9))
    {
      cmd_resetnode (parms);
    }
  else if (!strncasecmp (cmd, "RESETALLNODES", 13))
    {
      cmd_resetallnodes ();
    }
  else if (!strncasecmp (cmd, "EXPIRE", 6))
    {
      check_expired_units (time (NULL));
    }
  else if (!strncasecmp (cmd, "GEN", 3))
    {
      if (generating == 0)
	{
	  printf ("Scheduling generation of %d units\n", atoi (parms));
	  genwork (atoi (parms), "tempfile");
	}
      else
	{
	  printf ("Generating already taking place\n");
	}
    }
  else if (!strncasecmp (cmd, "SAVE", 4))
    {
      printf ("Saving all data\n");
      save_status_all ();
    }
  else if (!strncasecmp (cmd, "QUIT", 4))
    {
      printf ("Quit called, shutting down immediately\n");
      close_all_sockets ();
      save_status_all ();
      exit (0);
    }
}

void
cmd_register (char *parm)
{
  regallow = atoi (parm);

  if (regallow == 0)
    printf ("Registration disabled\n");
  else
    printf ("Registration enabled\n");

  return;
}

void
cmd_killnode (char *parm)
{
  int nodeid;
  struct node *n;
  struct unit *u;

  nodeid = atoi (parm);

  n = findnode (nodeid);

  if (n == NULL)
    {
      printf ("Invalid node %d\n", nodeid);
      return;
    }
  printf ("Removing node %d\n", n->id);
  remnode (n);
/* search for units assigned to this node */
  u = headunit;

  while (u != NULL)
    {
      if (u->assigned == nodeid)
	{
	  printf ("Unit %d assigned to removed node %d, clearing\n",
		  u->id, u->assigned);
	  u->status = UNIT_BUF;
	}
      u = u->next;
    }

}

void
cmd_resetnode (char *parm)
{
  int nodeid;
  struct node *n;

  nodeid = atoi (parm);

  n = findnode (nodeid);

  if (n == NULL)
    {
      printf ("Invalid node %d\n", nodeid);
      return;
    }
  printf ("Resetting stats for node %d\n", n->id);

  n->registered = time (NULL);
  n->completed = 0;


}

void
cmd_resetallnodes ()
{
  int now;
  struct node *n;

  n = headnode;
  now = time (NULL);

  while (n != NULL)
    {
      n->registered = now;
      n->completed = 0;
      n = n->next;
    }
  printf ("Reset all nodes\n");
}
