static const char rcsid[] =
  "$Id: units.c,v 1.16 2007/08/08 15:09:18 bert Exp $";

#include "dnetj.h"
#include "server.h"

unsigned int currentunit = 0;

struct unit *headunit = NULL;	/* the main head unit */
extern struct unit *headgen;
extern char *savefile;

int
remunit (struct unit *s)
{
  struct unit *x, *old;
  x = headunit;
  old = NULL;

if (s==NULL)
	return 0;

  while ((x) && (x != s))
    {
      old = x;
      x = x->next;
    }

  if (old == NULL)
    headunit = x->next;
  else
    old->next = x->next;

  if (x->recfile != NULL)
    {
      free (x->recfile);
    }
  free (x);
  return 1;
}

void
addunit (struct unit *si)
{
  struct unit *s = headunit, *old = NULL;
  si->next = NULL;
  while (s != NULL)
    {
      old = s;
      s = s->next;
    }
  if (old != NULL)
    {
      old->next = si;
    }
  else
    {
      headunit = si;
    }
}

struct unit *
newunit ()
{
  struct unit *si;
  si = (struct unit *) calloc (1, sizeof (struct unit));
  return si;
}

struct unit *
findunit (int s)
{
  struct unit *currunit;

  currunit = headunit;

  while (currunit != NULL)
    {
      if (currunit->id == s)
	{
	  return currunit;
	}
      currunit = currunit->next;
    }
  return NULL;
}

int
write_recfile (struct unit *wunit, char *filename)
{
  FILE *fd;

  fd = fopen (filename, "w");

  if (fd == NULL)
    {
      printf ("Saving recfile failed\n");
      return -1;
    }

  fprintf (fd, "%s", wunit->recfile);

#ifdef EBUG
  printf ("Saving recfile id %d : %s", wunit->id, wunit->recfile);
#endif

  if (fd != NULL)
    fclose (fd);

  return 0;
}

/* select a unit thats waiting to be assigned (unit->status == UNIT_BUF) */
/* if successfull, return pointer to struct unit, if failed return NULL */

struct unit *
get_spare ()
{
  struct unit *currunit = headunit;

  while (currunit != NULL)
    {
      if (currunit->status == UNIT_BUF)
	{
	  return currunit;
	}
      currunit = currunit->next;
    }
/* if it didnt find one, we get here */
  return NULL;
}

/* count how many spare pending units we have */
int
count_pending ()
{
  int x = 0;
  struct unit *currunit = headunit;

  while (currunit != NULL)
    {
      if (currunit->status != UNIT_COMPLETE)
	{
	  x++;
	}
      currunit = currunit->next;
    }
#ifdef EBUG
  printf ("DEBUG: count_pending() %d spare units to process\n", x);
#endif
  return x;
}

/* count how many spare pending units we have */
struct unit *
get_pending ()
{
  struct unit *currunit = headunit;

  while (currunit != NULL)
    {
      if (currunit->status != UNIT_COMPLETE)
	{
	  return currunit;
	}
      currunit = currunit->next;
    }
  return NULL;
}

/* encode_unit (string unit->recfile) 			*/
/* removes linefeeds, replaces with exclamation marks..	*/
/* for network transport 				*/
int
encode_unit (char *str)
{
  char *ptr;

  ptr = strchr (str, '\n');

  while (ptr != NULL)
    {
      ptr[0] = '!';
      ptr++;
      ptr = strchr (ptr, '\n');
    }
  return 0;
}

/* the opposite */
int
decode_unit (char *str)
{
  char *ptr;

  ptr = strchr (str, '!');

  while (ptr != NULL)
    {
      ptr[0] = '\n';
      ptr++;
      ptr = strchr (ptr, '!');
    }
  return 0;
}

/* save our current work units to the file specified in char *savefile*/
void
save_units ()
{
  int units = 0;
  struct unit *wunit = headunit;
  FILE *wfd;

  if (savefile == NULL)
    {				/* not declared yet */

    }

  printf ("Saving work units to %s\n", savefile);

  wfd = fopen (savefile, "w");

  fprintf (wfd, "# DNETJ WORKF 1\n");

  while (wunit != NULL)
    {

      fprintf (wfd, "UNIT:%u:%u:%u:%u:%u\n",
	       wunit->id, wunit->size, wunit->status, wunit->assigned,
	       wunit->progress);
      fprintf (wfd, "%s\n_EOF_\n", wunit->recfile);
#ifdef EBUG
      printf ("Saving recfile: %s", wunit->recfile);
#endif
      units++;
      wunit = wunit->next;

    }
  fclose (wfd);
  printf ("Total of %d work units saved\n", units);
}
