/* linked list for units */
struct unit
{
  unsigned int id;              /* work ID */
  unsigned int size;            /* size (how many iterations) */
  unsigned int status;          /* status - see below */
  unsigned int assigned;	/* node this is assigned to */
  unsigned int progress;		/* time this unit was assigned */
/* heres the john.rec actual file */
  char *recfile;
  struct unit *next;
};

/* unit status flags */
#define UNIT_SPARE	0	/* default state */
#define UNIT_BUF	1	/* unit is buffered, waiting to be sent */
#define UNIT_PENDING	2	/* unit has been assigned to a client, waiting for it to be completed */
#define UNIT_COMPLETE	3	/* client only - unit is complete */


void addunit (struct unit *);
void addunitg (struct unit *);
struct unit * findunit(int);
struct unit * newunit ();
int load_recfile (char *, int, struct unit *);
void save_units ();
int write_recfile(struct unit *, char *);
struct unit * get_spare();
int encode_unit (char *);
int decode_unit (char *);
int remunit (struct unit *);
int count_pending ();
struct unit * get_pending();

