#!/usr/bin/perl
#
# SamDecrypt - Output NT/LM hashes to pwdump type file
#              to go straight to John the Ripper
#
#              Also dumps password history suffixed by +n .
#
#              (c)2002 - Nathan Catlow <nathan@ccc-ltd.com>
#
#              If you make this program better, sling us a copy, cheers.
#
#use strict;

#
# Quite blatently ripped out of openSSL :-)
# I couldn't be arsed to reformat the list, hence the array stylie...
#
sub des_set_odd_parity {

	my ($key) = @_;
	my @odd_parity=(
	  	1,  1,  2,  2,  4,  4,  7,  7,  8,  8, 11, 11, 13, 13, 14, 14,
	  	16, 16, 19, 19, 21, 21, 22, 22, 25, 25, 26, 26, 28, 28, 31, 31,
		32, 32, 35, 35, 37, 37, 38, 38, 41, 41, 42, 42, 44, 44, 47, 47,
		49, 49, 50, 50, 52, 52, 55, 55, 56, 56, 59, 59, 61, 61, 62, 62,
		64, 64, 67, 67, 69, 69, 70, 70, 73, 73, 74, 74, 76, 76, 79, 79,
		81, 81, 82, 82, 84, 84, 87, 87, 88, 88, 91, 91, 93, 93, 94, 94,
		97, 97, 98, 98,100,100,103,103,104,104,107,107,109,109,110,110,
		112,112,115,115,117,117,118,118,121,121,122,122,124,124,127,127,
		128,128,131,131,133,133,134,134,137,137,138,138,140,140,143,143,
		145,145,146,146,148,148,151,151,152,152,155,155,157,157,158,158,
		161,161,162,162,164,164,167,167,168,168,171,171,173,173,174,174,
		176,176,179,179,181,181,182,182,185,185,186,186,188,188,191,191,
		193,193,194,194,196,196,199,199,200,200,203,203,205,205,206,206,
		208,208,211,211,213,213,214,214,217,217,218,218,220,220,223,223,
		224,224,227,227,229,229,230,230,233,233,234,234,236,236,239,239,
		241,241,242,242,244,244,247,247,248,248,251,251,253,253,254,254);
			
	my $i;
	my $str="        ";
	my @index=unpack("C8", $key);

	for ($i=0; $i<8; $i++) {
		$index[$i] = $odd_parity[$index[$i]];
	}

	$str=pack("C8", @index);

	return $str;
}
		
#
# Oh, oh my, ripped out of pwdump.
# bit shifting in perl is such a drag.
#
sub str_to_key {

	my ($str) = @_;
	my $key = "        ";
	my $i;

	vec($key, 0, 8) = vec($str, 0, 8) >> 1;
	vec($key, 1, 8) = ((vec($str, 0, 8) & 0x01) << 6) | (vec($str, 1, 8) >> 2);
	vec($key, 2, 8) = ((vec($str, 1, 8) & 0x03) << 5) | (vec($str, 2, 8) >> 3);
	vec($key, 3, 8) = ((vec($str, 2, 8) & 0x07) << 4) | (vec($str, 3, 8) >> 4);
	vec($key, 4, 8) = ((vec($str, 3, 8) & 0x0F) << 3) | (vec($str, 4, 8) >> 5);
	vec($key, 5, 8) = ((vec($str, 4, 8) & 0x1F) << 2) | (vec($str, 5, 8) >> 6);
	vec($key, 6, 8) = ((vec($str, 5, 8) & 0x3F) << 1) | (vec($str, 6, 8) >> 7);
	vec($key, 7, 8) = vec($str, 6, 8) & 0x7F;

	for ($i = 0; $i < 8; $i++) {
		vec($key, $i, 8) = (vec($key, $i, 8) << 1);
	}

	$key = des_set_odd_parity($key);
	return $key;
}

#
# Function to convert the RID to the first key. (thx pwdump!)
#
sub sid_to_key1 {

	my ($sid) = @_;
	my $str="        ";
	my $deskey;

	vec($str, 0, 8) = vec($sid, 3, 8);
	vec($str, 1, 8) = vec($sid, 2, 8);
	vec($str, 2, 8) = vec($sid, 1, 8);
	vec($str, 3, 8) = vec($sid, 0, 8);
	vec($str, 4, 8) = vec($str, 0, 8);
	vec($str, 5, 8) = vec($str, 1, 8);
	vec($str, 6, 8) = vec($str, 2, 8);

	$deskey = str_to_key($str);
	return $deskey;
}

#
# Function to convert the RID to the second decrypt key. (thx pwdump!)
#
sub sid_to_key2 {

	($sid) = @_;
	
	my $str="        ";
	my $deskey;

	vec($str, 0, 8) = vec($sid, 0, 8);
	vec($str, 1, 8) = vec($sid, 3, 8);
	vec($str, 2, 8) = vec($sid, 2, 8);
	vec($str, 3, 8) = vec($sid, 1, 8);
	vec($str, 4, 8) = vec($str, 0, 8);
	vec($str, 5, 8) = vec($str, 1, 8);
	vec($str, 6, 8) = vec($str, 2, 8);

	$deskey = str_to_key($str);
	return $deskey;
}

#
# Unicode to Ascii
#
sub uni_to_ascii {

	my ($str) = @_;
	my $i;
	my $out;

	for ($i = 0; $i < length($str); $i+=2) {
		$out .= substr($str, $i, 1);
	}

	return $out;
}

#
# Wrap it up in a nice function
#
sub decrypt_hash {

	my ($rid, $in_hash) = @_;
	
	my $key1 = sid_to_key1($rid);
	my $key2 = sid_to_key2($rid);

	my $cipher = new Crypt::DES $key1;
	my $out_hash = $cipher->decrypt(substr($in_hash, 0, 8));
	my $cipher = new Crypt::DES $key2;
	$out_hash .= $cipher->decrypt(substr($in_hash, 8, 8));

	return $out_hash;
}

#
# OK, fair play, pwdump again.
# but I take all credit for the PW history processing, and the offset for NT PW
# as well as poor perl.
#
sub split_v_record {

	($record, $rid) = @_;

	my $pw_LM;
	my $pw_NT;

	my $name_offset = unpack("I1", substr($record, 0x0c)) + 204;
	my $name_len = unpack("I1", substr($record, 0x10));
	my $name = substr($record, $name_offset, $name_len);

	$name=uni_to_ascii($name);

	my $fullname_offset = unpack("I1", substr($record, 0x18)) + 204;
	my $fullname_len = unpack("I1", substr($record, 0x1c));
	my $fullname = substr($record, $fullname_offset, $fullname_len);

	my $comment_offset = unpack("I1", substr($record, 0x24)) + 204;
	my $comment_len = unpack("I1", substr($record, 0x28));
	my $comment = substr($record, $comment_offset, $comment_len);

	my $homedir_offset = unpack("I1", substr($record, 0x48)) + 204;
	my $homedir_len = unpack("I1", substr($record, 0x4c));
	my $homedir = substr($record, $homedir_offset, $homedir_len);

	my $LM_offset = unpack("I1", substr($record, 0x9c)) + 204;
	my $NT_offset = unpack("I1", substr($record, 0xa8)) + 204;

	if ($LM_offset < length($record)) {
		$pw_LM = substr($record, $LM_offset, 16);
		$pw_NT = substr($record, $NT_offset, 16);

		$pw_LM = decrypt_hash($rid, $pw_LM);
		$pw_NT = decrypt_hash($rid, $pw_NT);
	}

	my $NT_hist_offset = unpack("I1", substr($record, 0xb4)) + 204;
	my $NT_hist_len = unpack("I1", substr($record, 0xb8));
	my $LM_hist_offset = unpack("I1", substr($record, 0xc0)) + 204;
	my $LM_hist_len = unpack("I1", substr($record, 0xc4));
	
	print "\n";
	print "RID       : ".unpack("N1", $rid)."\n";
	print "User      : $name\n";
	print "Full Name : $fullname\n";
	print "Comment   : $comment\n";
	print "HomeDir   : $homedir\n";
	print "Password  :---------------------------------\n";
	print "LanMan    : ".unpack("H32", $pw_LM)."\n";
	print "NT        : ".unpack("H32", $pw_NT)."\n";
	print "PW History:---------------------------------\n";
	print OUT "$name:".unpack("N1", $rid).":".unpack("H32", $pw_LM).":".unpack("H32", $pw_NT).":::\n";

	$count = 0;
	for ($i = 0; $i < $LM_hist_len; $i+=16) {
	
		my $NT = substr($record, $NT_hist_offset + $i, 16);
		my $LM = substr($record, $LM_hist_offset + $i, 16);
		
		$LM = decrypt_hash($rid, $LM);
		$NT = decrypt_hash($rid, $NT);

		print "LanMan    : ".unpack("H32", $LM)."\n";
		print "NT        : ".unpack("H32", $NT)."\n";

		$newname = $name."+".$count;

		# The first entry is always the same as the PW, M$ Doh!
		if ($count > 0) {
			print OUT "$name+$count:".unpack("N1", $rid).":".unpack("H32", $LM).":".unpack("H32", $NT).":::\n";
		}
		$count+=1;
	}

	
	
}
	
# Main
#
#
#
use Crypt::DES;

open(OUT, ">./sam.out");
opendir(DIR, "/mnt/reg/SAM/Domains/Account/Users/") || die "Have you mounted?";

print "Opening Policy...\n";
open (POL, "/mnt/reg/SAM/Domains/Account/F") || die "No policy?";
read(POL, $policy, 16384);
close POL;
my $no_saved_pw = unpack("I1", substr($policy, 0x52));

print "Saved Passwords: $no_saved_pw\n";

my $dir;
my $rid="    ";

while ($dir = readdir( DIR )) {
	if ( $dir eq "." || $dir eq ".." || $dir eq ".SD" || $dir eq "Names" || $dir eq "Unnamed-Value") {
		next;
	}

	open( FILE, "/mnt/reg/SAM/Domains/Account/Users/$dir/V" ) || die "Cannot find V entry!";
	binmode FILE;
	$len = read(FILE, $entry, 16384);
	$rid = pack('H8', $dir);
	split_v_record($entry, $rid);
	close FILE;
}

exit;
