/*
   MDCrack.c
   MD5 hash collision bruteforce

   *******************************************
   derived from the RSA Data
   Security, Inc. MD5 Message-Digest Algorithm
   *******************************************

   Try every passwords up to 8 chars length.
   Usefull to crack authentication protocols using paswords MD5 hash.
   Use it only to validate a new password choice/something like that 
   and nothing illegal.

   Author: Gregory Duchemin 
   Email : c3rb3r@hotmail.com 

   Version 0.1   Date: 21 Feb 2001.
   Version 0.2   Date: 03 Mar 2001.
*/


#include <stdio.h>
#include <unistd.h>
#include <time.h>
#include <string.h>
#include <sys/types.h>
#include <signal.h>
#include "generic.h"



void hashprint(unsigned char[]);

unsigned int count;
unsigned int verbosity=0;
unsigned int custom=0;
unsigned int all=0;
int counter=0;
int elapsed;
char target[33];
char *crack();
char *alfa;
char test[9];
extern int optind;
extern char *optarg;
time_t start;

void handle()
{
 FILE *des;
 elapsed=(unsigned int)(time(NULL)-start);
 if (!elapsed) elapsed=1;
 des=fopen("/tmp/.mdcrack.resume", "w+");
 if (des)
  {
   fprintf(des, "%s %s %d %d %s", target, test, verbosity, custom, alfa+1);
   fclose(des);
  }
 printf("\n\nGenerating resume file /tmp/.mdcrack.resume");
 printf("\n###########################################\n%s <-- string \nCollision(s) tested : %u in %u second(s).\nAverage of %u tests/sec.\n\n", test, count, elapsed, count/elapsed);

 fflush(stdout);
 exit (0);
}




void usage(void)
{
 printf("\nMDCrack version 0.2\nT00l to bruteforce password MD5 hashes.\n\nUsage: MDCrack [-h] [-v] [-a] [-s string] [digest] \n-h : (h)elp, this text\n-v : set (v)erbose mode\n-a : find (a)ll collisions (won't stop to the first found)\n-s string : feed a custom characters (s)tring\nNo option at all will force mdcrack to resume a previously stopped session\n\nAuthor: Gregory Duchemin ( c3rb3r@hotmail.com ).\n\n*******************************************\nderived from the RSA Data Security Inc.\nMD5 Message-Digest Algorithm\n*******************************************\n\n");
}



int main (argc, argv)
     int argc;
     char *argv[];
{
  int i;
  char *found;
  FILE *des1;
  char c;
  char resume[9];
  char value[33];

  bzero(resume, 9);
  bzero(value, 33);
  alfa=(char *)malloc(64);
  strcpy(alfa+1, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789");
  *alfa='\0';




 if (argc==1) 
  {
   if ((des1=fopen("/tmp/.mdcrack.resume", "r")) == NULL )
    {
     usage();
     printf("\n\nError: No resume file found. \n\n");
     exit(0); 
    }
  fscanf(des1, "%32s %8s %d %d %s", value, resume, &verbosity, &custom, alfa+1);
  printf("\n\n/tmp/.mdcrack.resume file exist !\nresuming last session..... \n       ( hash: %s last try: %s)\n\n", value, resume);
  fflush(stdout); 
  sleep(2);
  if (!(found=crack(value, resume)))
   {
    printf("\nsorry, did not succeed to find at least one collision.\n\n");
    return(1);
   }
  return(0);  
 }


  while(1)
  {
  c=getopt(argc, argv, "hvas:");
  if (c==-1)
	 break;

  switch(c)
  {
      case 'h':
      usage(); 
      exit(0);
      break;

      case 'v':
      verbosity=1;
      break;

      case 'a':
      all=1;
      break;

      case 's':
      custom=1;
      realloc(alfa, strlen(optarg)+1);
      strcpy(alfa+1, optarg); 
      *(alfa)='\0';
      break;

      case '?':
      usage();
      exit(0);
      break;

      default:
      usage();
      break;
  }
  }
  

if (optind+1<=argc)
 {
  if (strlen(*(argv+optind)) != 32)
    {
      printf("\n\n not a md5 digest....must have 16 bytes length (32 ascii digits from 0 to F).\n\n");
      return(1);
    }
  if ((verbosity) && (custom)) 
      printf("\n\n Using custom string : %s \n\n", alfa+1);
    if (!(found=crack(*(argv+optind), resume)))
    {
      printf("\nsorry, did not succeed to find at least one collision.\n\n");
      return(1);
    }  
  return (0);
 }
 else
 {
  usage();
  exit(0);
 }

}



int ascii2bin(copy, conv, mov)
     char *copy;
     char *conv;
     char *mov;
{
  int i,j,k;
  for (i=0;i<32;i+=2)
    {
      j=0;
      while ((conv[j]!=(*copy)) && (j<16)) j++;
      k=0;
      while ((conv[k]!=(*(copy+1))) && (k<16)) k++;
      *mov= (char) ((j<<4) & 0xf0);
      *mov= (*mov)| (char) (k & 0x0f);
      copy+=2;
      mov++;
    }
  return(1);
}


int up2low(input)
     char *input;
{
  int i;
  for (i=0; i<32; i++)
    if ((*(input+i) >= 65) && (*(input+i) <= 70))
        *(input+i)=*(input+i)+32;
  return(1);
}


char *crack(input, resume)
     char *input;
     char *resume;
{
  char conv[]="0123456789abcdef";
  register char *a,*b,*c,*d,*e,*f,*g,*h;
  register char *result;
  char *copy;
  register int MAX=(unsigned int) alfa+strlen(alfa+1)+1;
  register int MIN=(unsigned int) alfa+1; 
  unsigned char i,j,k; 
  char *mov;
  MD5_CTX context;
  char digest[16];

 
  bzero(digest, 16);
  mov=digest;
  copy=input;
  strncpy(target, input, 32);
  
    a=b=c=d=e=f=g=alfa;
    if (resume[0])
    {
     for (i=0; i<strlen(resume); i++)
       for (j=0;j<strlen(alfa+1);j++)
         if (resume[i]==alfa[j])
            { 
             if (!i)   h=alfa+j;
             if (i==1) g=alfa+j;
             if (i==2) f=alfa+j;
             if (i==3) e=alfa+j;
             if (i==4) d=alfa+j;
             if (i==5) c=alfa+j;
             if (i==6) b=alfa+j;
             if (i==7) a=alfa+j;
            }
    }
  else
    h=(char *)MIN;


  up2low(input);
  ascii2bin(copy, conv, mov);
    
  
  result=(char *)malloc(20);

  bzero(test, 9);
  signal(SIGINT, handle);
  MD5Init (&context);
  start=time(NULL);
 

  

  for(;a<(char *)MAX;a++)
    {
       *(test+7)=*a;
      for(;b<(char *)MAX;b++)
	{
	  *(test+6)=*b;
	  for(;c<(char *)MAX;c++)
	    {
	      *(test+5)=*c;
	      for(;d<(char *)MAX;d++)
		{
		  *(test+4)=*d;
		  for(;e<(char *)MAX;e++)
		    {
		      *(test+3)=*e;
		      for(;f<(char *)MAX;f++)
			{
			  *(test+2)=*f;
			  for(;g<(char *)MAX;g++)
			    {
			      *(test+1)=*g;
			      for(;h<(char *)MAX;h++)
				{
				  *test=*h;
                                  MD5Init (&context);
                                  MD5Update (&context, test, strlen(test));
                                  MD5Final (result, &context);
                                  if (verbosity)
                                    {
				      puts("\n");
                                      printf("%s ",test);
                                      puts(" <-- string.");
                                      hashprint (result);
                                      puts(" <-- hash.");  
                                      hashprint(digest);
                                      puts(" <-- reference.\n\n");
                                      fflush(stdout);
				      }
                                  count++;
				  if ((*digest==*result)&&(*(digest+1)==*(result+1))&&(*(digest+2)==*(result+2))&&(*(digest+3)==*(result+3))&&(*(digest+4)==*(result+4))&&(*(digest+5)==*(result+5))&&(*(digest+6)==*(result+6))&&(*(digest+7)==*(result+7))&&(*(digest+8)==*(result+8))&&(*(digest+9)==*(result+9))&&(*(digest+10)==*(result+10))&&(*(digest+11)==*(result+11))&&(*(digest+12)==*(result+12))&&(*(digest+13)==*(result+13))&&(*(digest+14)==*(result+14))&&(*(digest+15)==*(result+15)))
				    {
				      printf("\n**********************************************\nCollision found ! => %s\n", test);  
                                      elapsed=(unsigned int)(time(NULL)-start);
                                      if (!elapsed) elapsed=1;
                                      printf("\n\nCollision(s) tested : %u in %u second(s).\nAverage of %u tests/sec.\n\n", count, elapsed, count/elapsed);

                                      fflush(stdout);
                                      if (!all)
				         return(result);
				    }
				}
                              h=(char *)MIN;
			    }
                           g=(char *)MIN;
			}
                       f=(char *)MIN;
		    }
                   e=(char *)MIN;
		}
              d=(char *)MIN;
	    }
          c=(char *)MIN;
	}
      b=(char *)MIN;
    }

  return(NULL);

}

void hashprint (digest)
unsigned char digest[16];
{
  int i;

  for (i = 0; i < 16; i++)
    printf ("%02x", digest[i]);
}
