/*
   MDCrack.c
   MD5 collision bruteforcer

   *******************************************
   derived from the RSA Data
   Security, Inc. MD5 Message-Digest Algorithm
   *******************************************

   Try every passwords up to 8 chars length.
   Useful to crack authentication protocols using paswords MD5 hash.
   Use it only to validate a new password choice/something like that 
   and nothing illegal.

   Author: Gregory Duchemin 
   Email : c3rb3r@hotmail.com 
   www : http://mdcrack.multimania.com

   Version 0.1   Date: 21 Feb 2001.
   Version 0.2   Date: 03 Mar 2001.
   Version 0.3   Date: 05 Mar 2001.
   Version 0.4   Date: 07 Mar 2001.
   Version 0.5   Date: 08 Mar 2001.
   Version 0.6   Date: 14 Mar 2001.
   Version 0.7   Date: 18 Mar 2001.
   Version 0.8   Date: 01 Apr 2001.
*/


#include <stdio.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/timeb.h>
#include <string.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/stat.h>
#include "generic.h"




#ifndef RESUME_FILE
#define RESUME_FILE "/tmp/.mdcrack.resume"
#endif
#ifndef BENCH_HASH
#define BENCH_HASH "ffffffffffffffffffffffffffffffff"
#endif
#ifndef ALFA
#define ALFA "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUWXYZ"
#endif






void hashprint(unsigned int *);

unsigned int count;
unsigned long count2;
unsigned int verbosity=0;
unsigned int benchmode=0;
unsigned int duration=0;
unsigned int custom=0;
unsigned int all=0;
unsigned int ender=0;
unsigned int beginer=0;
unsigned int hwrite=0;
unsigned int fastwrite=0;
unsigned int fast=0;
int counter=0;
FILE *desw;
long elapsed;
long elapsed_u;
char target[33];
char *filename;
int crack();
int crack_end();
int crack_verbose();
int crack_rw();
char *alfa;
char *test;
char *total;
extern int optind;
extern char *optarg;
extern void Decode(unsigned int *, unsigned char *, int);
extern void Encode(unsigned char *, unsigned int *, int);
extern int MD5Transform( unsigned int*, unsigned char*, unsigned int);
int md5_reverse(unsigned int *, unsigned int*, unsigned int *);
long start;
long start_u;
char *begin;
char *end;



void handle()
{
 FILE *des;
 struct timeval *ft;
 float diff;
 unsigned int size;
 struct stat *secure;
 int key;

 ft=(struct timeval *) malloc(sizeof(struct timeval));
 gettimeofday(ft, NULL);
 elapsed=(ft->tv_sec)-start;
 elapsed_u=(ft->tv_usec)-start_u;


 size=strlen(total);
 total[size-1]=0x00;

 if (hwrite)
 {
	 printf("\nOutput Hashes file \"%s\" is now closed.\n", filename);
	 fclose(desw);
 }

if (!benchmode)
{
 secure=(struct stat*)malloc(1*sizeof(struct stat));
 key=lstat(RESUME_FILE, secure);
 if (S_ISLNK(secure->st_mode))
     printf("\n"RESUME_FILE" is a symlink !..no resume file created, operation too dangerous.\n\n");
  else
  {
 des=fopen(RESUME_FILE, "w+");
 if (des)
  {
	  if (!hwrite) strcpy(filename, "none");
   fprintf(des, "%s %s %d %d %s %d %s ", target, total, verbosity, custom, alfa+1, hwrite, filename);
   fclose(des);
  }
 printf("\nGenerating resume file "RESUME_FILE"\n");
  } 
}

 if ((elapsed_u<10000) && (!elapsed))
  {

if (benchmode)
 printf("\nBenchmark result."); 

   printf("\n**********************************************\n%s <-- string \n", total);  
   printf("\n\nCollisions tested in less than 10 millisec.\nnot enough for statistics report..sorry.\n\n");
   fflush(stdout);
  }
 else
  {

if (elapsed_u < 0)
	{
	 elapsed_u=1000000+elapsed_u;
         if (elapsed>0) elapsed--;
	}

 diff=(float)elapsed+((float)elapsed_u/1000000);
 

if (benchmode)
 printf("\nBenchmark result."); 

 printf("\n###########################################\n%s <-- string \nCollision(s) tested : %u in %lu second(s), %lu millisec, %lu microsec.\nAverage of %.1f hashes/sec.\n\n", total, count, elapsed, (elapsed_u/1000), (elapsed_u%1000),(float) ((float)count/diff));

 fflush(stdout);
}
 exit (0);
}




void usage(void)
{
 printf("\nMDCrack version 0.8\nT00l to bruteforce password MD5 hashes.\n\nUsage: MDCrack [-h] [-v | -V] [-d] [-W file -F] [-b randomizer] [-e randomizer] [-t secs] [-a] [-s string] [digest] \n-h : (h)elp, this text\n-v : set (v)erbose mode\n-V : more (V)erbose\n-d : (d)elete any resume-file \n-W : file where to (w)rite all computed hashes\n-F : (F)ast write (Hashes file is no longer human-readable)\n-b : string to concatenate (b)efore passwords.\n-e : string to concatenate at passwords (e)nd.\n-t : Benchmark mode (t)imer, compute during secs seconds\n-a : find (a)ll collisions (won't stop to the first found)\n-s : feed a custom charset (s)tring\nNo option at all will force mdcrack to resume a previously stopped session\n\nAuthor: Gregory Duchemin\nEmail: c3rb3r@hotmail.com\nWWW: http://mdcrack.multimania.com \nGreetings to Simeon Pilgrim\n\n*******************************************\nderived from the RSA Data Security Inc.\nMD5 Message-Digest Algorithm\n*******************************************\n\n");
}


int cleanup(reference)
	char *reference;
{

   if (remove(reference))
     return(1); 
return(0);
}




void sorry(void)
{
 printf("\n\nDid not suceed to crack it...sorry.\n\n");
}


void bad_digest(void)
{
 printf("\n\nnot a md5 digest....must have 16 bytes length (32 ascii digits from 0 to F).\n\n");
}




int main (argc, argv)
     int argc;
     char *argv[];
{
  int i;
  int found;
  FILE *des1;
  char c;
  char resume[9];
  char value[33];
  char feed[500];

  bzero(resume, 9);
  bzero(value, 33);
  alfa=(char *)malloc(64);
  strcpy(alfa+1, ALFA);
  *alfa='\0';


 filename=(char *)malloc(512);


 if (argc==1) 
  {
   if ((des1=fopen(RESUME_FILE, "r")) == NULL )
    {
     usage();
     printf("\n\nError: No resume file found. \n\n");
     exit(0); 
    }
  fscanf(des1, "%32s %8s %d %d %s %d %s", value, resume, &verbosity, &custom, alfa+1, &hwrite, filename);
  printf("\n\n"RESUME_FILE" file exist !\nresuming last session..... \n       ( \n        hash: %s\n        last try: \"%s\"\n        Output-file: %s\n       )\n\n", value, resume, filename);
  fflush(stdout); 
  if (hwrite)
   {
    desw=fopen(filename, "a+");
    if (desw==NULL)
    {
     usage();
     printf("\n\nError: output file was not created. \n\n");
     exit(0); 
    }
   }
 sleep(2);
 }
 else
 {

  while(1)
  {
  c=getopt(argc, argv, "hvVdas:t:b:e:W:F");
  if (c==-1)
	 break;

  switch(c)
  {
      case 't':
      benchmode=1;
      duration=atoi(optarg); 
      break;

      case 'h':
      usage(); 
      exit(0);
      break;


      case 'd':
      if (cleanup(RESUME_FILE)) 
      {
      usage();
      printf("\n\n\""RESUME_FILE"\" not found.\n\n");
      exit(0);
      }
      else
      {
	      printf("\n\nPrevious resume file \""RESUME_FILE"\" deleted.\n\n");
	      exit(0);
      }
      break;

      case 'v':
      verbosity=1;
      break;

      case 'V':
      verbosity=2;
      break;

      case 'b':
      begin=(char *)malloc(strlen(optarg)+1);
      strcpy(begin, optarg);
      beginer=1;
      break;

      case 'e':
      end=(char *)malloc(strlen(optarg)+1);
      strcpy(end, optarg);
      ender=1;
      break;

      case 'a':
      all=1;
      break;

      case 's':
      custom=1;
      realloc(alfa, strlen(optarg)+2);
      strcpy(alfa+1, optarg); 
      *(alfa)='\0';
      break;

      case 'W':
      if ((desw=fopen(optarg, "w+")) == NULL )
      {
       usage();
       printf("\n\nError: output file was not created. \n\n");
       exit(0); 
      }
      strcpy(filename, optarg);
      hwrite=1;
      break;

      case 'F':
      fastwrite=1;
      break;

      case '?':
      usage();
      exit(0);
      break;

      default:
      usage();
      break;
   }
  }
 }


if ((optind+1<=argc) || (argc==1) || (benchmode))
 {

   if (argc==1)
      strcpy(feed, value);
   else
   {
    if (benchmode)
    strcpy(feed, BENCH_HASH);
      else
     strcpy(feed, *(argv+optind));
   }

   if (strlen(feed) != 32)
    {
      bad_digest(); 
      return(1);
    }


   if (custom) 
   printf("\n\nUsing custom charset : %s \n\n", alfa+1);
   else
   printf("\n\nUsing default charset : %s \n\n",alfa+1);


   if (verbosity)
    {
     if (!(found=crack_verbose(feed, resume)))
      {
      sorry();
      return(1);
      }  
     return (0);
    }

if (hwrite)
{
   if (!(found=crack_rw(feed, resume)))
   {
    sorry();
    return(1);
   }  
   return(0);
}

 if (ender)
   {
   if (!(found=crack_end(feed, resume)))
   {
    sorry();
    return(1);
   }  
   return(0);
  }
  
 if (!(found=crack(feed, resume)))
   {
    sorry();
    return(1);
   }  
    return (0);
 }
 else
 {
  usage();
  exit(0);
 }

}



int ascii2bin(copy, conv, mov)
     char *copy;
     char *conv;
     char *mov;
{
  int i,j,k;
  for (i=0;i<32;i+=2)
    {
      j=0;
      while ((conv[j]!=(*copy)) && (j<16)) j++;
      k=0;
      while ((conv[k]!=(*(copy+1))) && (k<16)) k++;
      *mov= (char) ((j<<4) & 0xf0);
      *mov= (*mov)| (char) (k & 0x0f);
      copy+=2;
      mov++;
    }
  return(1);
}


int up2low(input)
     char *input;
{
  int i;
  for (i=0; i<32; i++)
    if ((*(input+i) >= 65) && (*(input+i) <= 70))
        *(input+i)=*(input+i)+32;
  return(1);
}





int crack(input, resume)
     char *input;
     char *resume;
{
  char conv[]="0123456789abcdef";
  register char *a,*b,*c,*d,*e,*f,*g,*h;
  unsigned int *result2;
  char *copy;
  register unsigned int MAX=(unsigned int) alfa+strlen(alfa+1)+1;
  register unsigned int MIN=(unsigned int) alfa+1; 
  unsigned char i,j; 
  unsigned int offset=0;
  char *mov;
  char digest[16];
  unsigned int digest2[4];
  struct timeval *tp;
  struct timeval *ft;
  float diff; 
  unsigned int* x1;
  unsigned int working[4];
  unsigned int size=12;
  register unsigned int len;
  unsigned int tail;

 
  ft=(struct timeval *)malloc(sizeof(struct timeval));
  tp=(struct timeval *)malloc(sizeof(struct timeval)); 
  bzero(digest, 16);
  mov=digest;
  copy=input;
  strncpy(target, input, 32);
  
    a=b=c=d=e=f=g=alfa;

    if (resume[0])
    {
     for (i=0; i<strlen(resume); i++)
       for (j=1;j<strlen(alfa+1);j++)
         if (resume[i]==alfa[j])
            { 
             if (!i)   h=alfa+j;
             if (i==1) g=alfa+j;
             if (i==2) f=alfa+j;
             if (i==3) e=alfa+j;
             if (i==4) d=alfa+j;
             if (i==5) c=alfa+j;
             if (i==6) b=alfa+j;
             if (i==7) a=alfa+j;
            }
    }
  else
    h=(char *)MIN;


  up2low(input);
  ascii2bin(copy, conv, mov);
  Decode(digest2, mov, 16);  
  
  digest2[0] -= 0x67452301;
  digest2[1] -= 0xefcdab89;  
  digest2[2] -= 0x98badcfe;  
  digest2[3] -= 0x10325476;

  if (begin) offset+=strlen(begin);
  if ((9+offset)>=12) size=(9+offset);
  test=(char *)malloc(size);
  if (!test)
   {
     printf("\n\n Malloc error.\n\n");
     exit(0);
   }
  total=test;
  bzero(test, size);
  if (begin) 
  {
  strcpy(test, begin);
  test=test+strlen(begin);
  }
  len=1+offset; 
  x1=(unsigned int*)total;


  md5_reverse(working, digest2, x1);			  

  signal(SIGINT, handle);
  if (benchmode)
    {
     alarm(duration);
     signal(SIGALRM, handle);
    }

  gettimeofday(tp, NULL);
  start=tp->tv_sec;
  start_u=tp->tv_usec;


  for(;a<(char *)MAX;a++)
    {
       *(test+7)=*a;
      for(;b<(char *)MAX;b++)
	{
	  *(test+6)=*b;
	  for(;c<(char *)MAX;c++)
	    {
	      *(test+5)=*c;
	      for(;d<(char *)MAX;d++)
		{
		  *(test+4)=*d;
		  for(;e<(char *)MAX;e++)
		    {
		      *(test+3)=*e;
		      for(;f<(char *)MAX;f++)
			{
			  *(test+2)=*f;
			  for(;g<(char *)MAX;g++)
			    {
			      *(test+1)=*g;
			      for(;h<(char *)MAX;h++)
				{
				  *test=*h;
                                  tail=(unsigned int) len << 3;
				  total[len]=0x80;
                                  /*md5_reverse(working, digest2, x1);			  */
				  count++;

				  if (MD5Transform(working, total, tail))
				  {
                               gettimeofday(ft, NULL);
                               elapsed=(ft->tv_sec)-start;
                               elapsed_u=(ft->tv_usec)-start_u;
                               
			        
                               total[len]=0x00;
			       if ((elapsed_u<10000) && (!elapsed))
                                {
		               printf("\n**********************************************\nCollision found ! => %s\n", total);  
                               printf("\n\nCollision found in less than 10 millisec.\nnot enough for statistics report..sorry.\n\n");
                               fflush(stdout);
                               if (!all)
			         return(1);
                                 }
                               else
                                {
                               if (elapsed_u < 0)
	                         {
	                          elapsed_u=1000000+elapsed_u;
                                  if (elapsed>0) elapsed--;
	                         }
                               diff=(float)elapsed+((float)elapsed_u/1000000);
		               printf("\n**********************************************\nCollision found ! => %s\n", total);  

                              printf("\n\nCollision(s) tested : %u in %u second(s), %u millisec, %u microsec.\nAverage of %.1f hashes/sec.\n\n", count, elapsed, (elapsed_u/1000), (elapsed_u%1000), ((float)count/diff));
                                      fflush(stdout);
                                      if (!all)
				         return(1);
				    }
                                  }
				}
                              h=(char *)MIN;
			      if (len<2+offset) len=2+offset;
			    }
                           g=(char *)MIN;
			   if (len<3+offset) len=3+offset;
			}
                       f=(char *)MIN;
		       if (len<4+offset) len=4+offset;
		    }
                   e=(char *)MIN;
		   if (len<5+offset) len=5+offset;
		}
              d=(char *)MIN;
	      if (len<6+offset) len=6+offset;
	    }
          c=(char *)MIN;
	  if (len<7+offset) len=7+offset;
	}
      b=(char *)MIN;
      if (len<8+offset) len=8+offset;
    }

  return(0);

}



int crack_verbose(input, resume)
     char *input;
     char *resume;
{
  char conv[]="0123456789abcdef";
  register char *a,*b,*c,*d,*e,*f,*g,*h;
  unsigned int *result2;
  char *copy;
  unsigned int offset=0;
  register int MAX=(unsigned int) alfa+strlen(alfa+1)+1;
  register int MIN=(unsigned int) alfa+1; 
  unsigned char i,j; 
  char *mov;
  char digest[16];
  unsigned int digest2[4];
  struct timeval *tp;
  struct timeval *ft;
  float diff;
  MD5_CTX context;
  register unsigned int len;
  unsigned int working[4];
  unsigned int size=12;
  unsigned char byte1, byte2, byte3, byte4;


  ft=(struct timeval *)malloc(sizeof(struct timeval));
  tp=(struct timeval *)malloc(sizeof(struct timeval)); 
  bzero(digest, 16);
  mov=digest;
  copy=input;
  strncpy(target, input, 32);
  
    a=b=c=d=e=f=g=alfa;
    if (resume[0])
    {
     for (i=0; i<strlen(resume); i++)
       for (j=0;j<strlen(alfa+1);j++)
         if (resume[i]==alfa[j])
            { 
             if (!i)   h=alfa+j;
             if (i==1) g=alfa+j;
             if (i==2) f=alfa+j;
             if (i==3) e=alfa+j;
             if (i==4) d=alfa+j;
             if (i==5) c=alfa+j;
             if (i==6) b=alfa+j;
             if (i==7) a=alfa+j;
            }
    }
  else
    h=(char *)MIN;


  up2low(input);
  ascii2bin(copy, conv, mov);
  Decode(digest2, mov, 16);  
  


  
  if (begin) offset=strlen(begin);
  if (end) offset+=strlen(end);
  if ((9+offset)>=12) size=(9+offset);
  test=(char *)malloc(size);
  if (!test)
   {
     printf("\n\n Malloc error.\n\n");
     exit(0);
   }
  total=(char *)malloc(size);

  bzero(test, size);
  if (begin) 
    test=test+strlen(begin);

		  


  signal(SIGINT, handle);
  gettimeofday(tp, NULL);
  start=tp->tv_sec;
  start_u=tp->tv_usec;

len=offset+1;
  for(;a<(char *)MAX;a++)
    {
       *(test+7)=*a;
      for(;b<(char *)MAX;b++)
	{
	  *(test+6)=*b;
	  for(;c<(char *)MAX;c++)
	    {
	      *(test+5)=*c;
	      for(;d<(char *)MAX;d++)
		{
		  *(test+4)=*d;
		  for(;e<(char *)MAX;e++)
		    {
		      *(test+3)=*e;
		      for(;f<(char *)MAX;f++)
			{
			  *(test+2)=*f;
			  for(;g<(char *)MAX;g++)
			    {
			      *(test+1)=*g;
			      for(;h<(char *)MAX;h++)
				{
				  *test=*h;
				  *(context.count)=*(context.count+1)=0;
				  *(context.state)=0x67452301;
				  *(context.state+1)=0xefcdab89;
				  *(context.state+2)=0x98badcfe;
				  *(context.state+3)=0x10325476;
				  if (begin)
				  {
					  strcpy(total, begin); 
					  strcat(total, test);
				  }
				  else
                                  strcpy(total, test);
				  if (end)
                                    strcat(total, end);

                                  MD5Update (&context, total, len);
                                  result2=(unsigned int*)MD5Final(&context);
				  
				  if (hwrite)
				  if (!fastwrite)
				  {
                                   fprintf(desw, " %s ", total);
                                   for (i=0; i<4; i++)
                                     {
#ifdef ISBIG_ENDIAN
                                      byte1=(unsigned char) ((result2[i])&0x000000ff);
	                              byte2=(unsigned char) ((result2[i]&0x0000ff00)>>8);
	                              byte3=(unsigned char) ((result2[i]&0x00ff0000)>>16);
	                              byte4=(unsigned char) ((result2[i]&0xff000000)>>24);
#else
	                              byte1=(unsigned char) ((result2[i])>>24);
	                              byte2=(unsigned char) ((result2[i]&0x00ff0000)>>16);
	                              byte3=(unsigned char) ((result2[i]&0x0000ff00)>>8);
	                              byte4=(unsigned char) ((result2[i])&0x000000ff);
#endif
    				      fprintf (desw,"%02x%02x%02x%02x",byte4, byte3, byte2, byte1);
				     }

				  }
				  else 
				  { 
				  fwrite(total, sizeof(char), strlen(total), desw);
				  fwrite(result2, sizeof(unsigned int),4, desw);
				  }

                                  printf("\n%s <-- string.\n",total);
				  if (verbosity==2)
				  {
                                  hashprint(result2);
                                  puts(" <-- hash.");  
                                  hashprint(digest2);
                                  puts(" <-- reference.\n\n");
				  }

                                  fflush(stdout);
                                  count++;
				 
                                  if ((*digest2==*result2)&&(*(digest2+1)==*(result2+1))&&(*(digest2+2)==*(result2+2))&&(*(digest2+3)==*(result2+3)))
				    {
				 

                               gettimeofday(ft, NULL);
                               elapsed=(ft->tv_sec)-start;
                               elapsed_u=(ft->tv_usec)-start_u;
                               if ((elapsed_u<10000) && (!elapsed))
                                {
		               printf("\n**********************************************\nCollision found ! => %s\n", total);  
                               printf("\n\nCollision found in less than 10 millisec.\nnot enough for statistics report..sorry.\n\n");
                               fflush(stdout);
                               if (!all)
			         return(1);
                                 }
                               else
                                {
                               if (elapsed_u < 0)
	                         {
	                          elapsed_u=1000000+elapsed_u;
                                  if (elapsed>0) elapsed--;
	                         }
                               diff=(float)elapsed+((float)elapsed_u/1000000);
		               printf("\n**********************************************\nCollision found ! => %s\n", total);  
                              printf("\n\nCollision(s) tested : %u in %u second(s), %u millisec, %u microsec.\nAverage of %.1f hashes/sec.\n\n", count, elapsed, (elapsed_u/1000), (elapsed_u%1000), ((float)count/diff));
                                      fflush(stdout);
                                      if (!all)
				         return(1);
				    }
                                 }
				}
                              h=(char *)MIN;
			      if (len<2+offset) len=2+offset;
			    }
                           g=(char *)MIN;
			   if (len<3+offset) len=3+offset;
			}
                       f=(char *)MIN;
		       if (len<4+offset) len=4+offset;
		    }
                   e=(char *)MIN;
		   if (len<5+offset) len=5+offset;
		}
              d=(char *)MIN;
              if (len<6+offset) len=6+offset;
	    }
          c=(char *)MIN;
	  if (len<7+offset) len=7+offset;
	}
      b=(char *)MIN;
      if (len<8+offset) len=8+offset;
    }

  return(0);

}


int crack_end(input, resume)
     char *input;
     char *resume;
{
  char conv[]="0123456789abcdef";
  register char *a,*b,*c,*d,*e,*f,*g,*h;
  unsigned int *result2;
  char *copy;
  register int MAX=(unsigned int) alfa+strlen(alfa+1)+1;
  register int MIN=(unsigned int) alfa+1; 
  unsigned char i,j; 
  unsigned int offset=0;
  char *mov;
  char digest[16];
  unsigned int digest2[4], tail;
  struct timeval *tp;
  struct timeval *ft;
  float diff;
  register unsigned int len;
  unsigned int* x1;
  unsigned int working[4];
  unsigned int size=12;


  ft=(struct timeval *)malloc(sizeof(struct timeval));
  tp=(struct timeval *)malloc(sizeof(struct timeval)); 
  bzero(digest, 16);
  mov=digest;
  copy=input;
  strncpy(target, input, 32);
  
    a=b=c=d=e=f=g=alfa;

    if (resume[0])
    {
     for (i=0; i<strlen(resume); i++)
       for (j=1;j<strlen(alfa+1);j++)
         if (resume[i]==alfa[j])
            { 
             if (!i)   h=alfa+j;
             if (i==1) g=alfa+j;
             if (i==2) f=alfa+j;
             if (i==3) e=alfa+j;
             if (i==4) d=alfa+j;
             if (i==5) c=alfa+j;
             if (i==6) b=alfa+j;
             if (i==7) a=alfa+j;
            }
    }
  else
    h=(char *)MIN;


  up2low(input);
  ascii2bin(copy, conv, mov);
  Decode(digest2, mov, 16);  
  
  digest2[0] -= 0x67452301;
  digest2[1] -= 0xefcdab89;  
  digest2[2] -= 0x98badcfe;  
  digest2[3] -= 0x10325476;

  if (begin) offset=strlen(begin);
  if (end) offset+=strlen(end); 
  if ((9+offset)>=12) size=(9+offset);

  test=(char *)malloc(size);
  if (!test)
   {
     printf("\n\n Malloc error.\n\n");
     exit(0);
   }
  total=(char *)malloc(size);
  bzero(test, size);
  if (begin) 
   {
  strcpy(test, begin);
  test=test+strlen(begin);
   }
  
  x1=(unsigned int*)total;
  md5_reverse(working, digest2, x1);			  

  signal(SIGINT, handle);
  if (benchmode)
    {
     alarm(duration);
     signal(SIGALRM, handle);
    }
  gettimeofday(tp, NULL);
  start=tp->tv_sec;
  start_u=tp->tv_usec;

len=1+offset;
  for(;a<(char *)MAX;a++)
    {
       *(test+7)=*a;
      for(;b<(char *)MAX;b++)
	{
	  *(test+6)=*b;
	  for(;c<(char *)MAX;c++)
	    {
	      *(test+5)=*c;
	      for(;d<(char *)MAX;d++)
		{
		  *(test+4)=*d;
		  for(;e<(char *)MAX;e++)
		    {
		      *(test+3)=*e;
		      for(;f<(char *)MAX;f++)
			{
			  *(test+2)=*f;
			  for(;g<(char *)MAX;g++)
			    {
			      *(test+1)=*g;
			      for(;h<(char *)MAX;h++)
				{
				  *test=*h;
				 
                                  strcpy(total, test);
                                  strcat(total, end);
                                
                                  tail=(unsigned int) len << 3;
				  total[len]=0x80;
				  count++;

				  if (MD5Transform(working, total, tail))
				    {

                               gettimeofday(ft, NULL);
                               elapsed=(ft->tv_sec)-start;
                               elapsed_u=(ft->tv_usec)-start_u;

                               total[len]=0x00;
                               if ((!elapsed_u) && (!elapsed))
                                {
		               printf("\n**********************************************\nCollision found ! => %s\n", total);  
                               printf("\n\nCollision found in less than 1 millisecond\nnot enough for statistics report..sorry.\n\n");
                               fflush(stdout);
                               if (!all)
			         return(1);
                                 }
                               else
                                {
                               if (elapsed_u < 0)
	                         {
	                          elapsed_u=1000000+elapsed_u;
                                  if (elapsed>0) elapsed--;
	                         }
                               diff=(float)elapsed+((float)elapsed_u/1000000);
		               printf("\n**********************************************\nCollision found ! => %s\n", total);  
                              printf("\n\nCollision(s) tested : %u in %u second(s), %u millisec, %u microsec.\nAverage of %.1f tests/sec.\n\n", count, elapsed, (elapsed_u/1000), (elapsed_u%1000), ((float)count/diff));
                                      fflush(stdout);
                                      if (!all)
				         return(1);
				    }
                                  }
				}
                              h=(char *)MIN;
			      if (len<2+offset) len=2+offset;
			    }
                           g=(char *)MIN;
			   if (len<3+offset) len=3+offset;
			}
                       f=(char *)MIN;
		       if (len<4+offset) len=4+offset;
		    }
                   e=(char *)MIN;
		   if (len<5+offset) len=5+offset;
		}
              d=(char *)MIN;
	      if (len<6+offset) len=6+offset;
	    }
          c=(char *)MIN;
          if (len<7+offset) len=7+offset; 
	}
      b=(char *)MIN;
      if (len<8+offset) len=8+offset; 
    }

  return(0);

}




int crack_rw(input, resume)
     char *input;
     char *resume;
{
  char conv[]="0123456789abcdef";
  register char *a,*b,*c,*d,*e,*f,*g,*h;
  unsigned int *result2;
  char *copy;
  register int MAX=(unsigned int) alfa+strlen(alfa+1)+1;
  register int MIN=(unsigned int) alfa+1; 
  unsigned char i,j; 
  unsigned int offset=0;
  char *mov;
  MD5_CTX context;
  char digest[16];
  unsigned int digest2[4];
  struct timeval *tp;
  struct timeval *ft;
  float diff;
  char *bufferw;
  register unsigned int len;
  unsigned char byte1, byte2, byte3, byte4;

  ft=(struct timeval *)malloc(sizeof(struct timeval));
  tp=(struct timeval *)malloc(sizeof(struct timeval)); 
  bzero(digest, 16);
  mov=digest;
  copy=input;
  strncpy(target, input, 32);
  
    a=b=c=d=e=f=g=alfa;

    if (resume[0])
    {
     for (i=0; i<strlen(resume); i++)
       for (j=1;j<strlen(alfa+1);j++)
         if (resume[i]==alfa[j])
            { 
             if (!i)   h=alfa+j;
             if (i==1) g=alfa+j;
             if (i==2) f=alfa+j;
             if (i==3) e=alfa+j;
             if (i==4) d=alfa+j;
             if (i==5) c=alfa+j;
             if (i==6) b=alfa+j;
             if (i==7) a=alfa+j;
            }
    }
  else
    h=(char *)MIN;


  up2low(input);
  ascii2bin(copy, conv, mov);
  Decode(digest2, mov, 16);  




  if (begin) offset=strlen(begin);
  test=(char *)malloc(9+offset);
  if (!test)
   {
     printf("\n\n Malloc error.\n\n");
     exit(0);
   }
  if (end)
	  total=(char *)malloc(9+offset);
  else
  total=test;
  bzero(test, 8+offset);
  if (begin) 
   {
  strcpy(test, begin);
  test=test+strlen(begin);
   }
  

  signal(SIGINT, handle);
  if (benchmode)
    {
     alarm(duration);
     signal(SIGALRM, handle);
    }
  gettimeofday(tp, NULL);
  start=tp->tv_sec;
  start_u=tp->tv_usec;

  len=1+offset;
  for(;a<(char *)MAX;a++)
    {
       *(test+7)=*a;
      for(;b<(char *)MAX;b++)
	{
	  *(test+6)=*b;
	  for(;c<(char *)MAX;c++)
	    {
	      *(test+5)=*c;
	      for(;d<(char *)MAX;d++)
		{
		  *(test+4)=*d;
		  for(;e<(char *)MAX;e++)
		    {
		      *(test+3)=*e;
		      for(;f<(char *)MAX;f++)
			{
			  *(test+2)=*f;
			  for(;g<(char *)MAX;g++)
			    {
			      *(test+1)=*g;
			      for(;h<(char *)MAX;h++)
				{
				  *test=*h;
				  *(context.count)=*(context.count+1)=0;
				  *(context.state)=0x67452301;
				  *(context.state+1)=0xefcdab89;
				  *(context.state+2)=0x98badcfe;
				  *(context.state+3)=0x10325476;
                                  if (end)
				  {
				  strcpy(total, test);
                                  strcat(total, end);
				  }
                                  MD5Update (&context, total, len);
                                  result2=(unsigned int*)MD5Final(&context);

				  if (!fastwrite)
				  {
                                   fprintf(desw, " %s ", total);
                                   for (i=0; i<4; i++)
                                     {
#ifdef ISBIG_ENDIAN
                                      byte1=(unsigned char) ((result2[i])&0x000000ff);
	                              byte2=(unsigned char) ((result2[i]&0x0000ff00)>>8);
	                              byte3=(unsigned char) ((result2[i]&0x00ff0000)>>16);
	                              byte4=(unsigned char) ((result2[i]&0xff000000)>>24);
#else
	                              byte1=(unsigned char) ((result2[i])>>24);
	                              byte2=(unsigned char) ((result2[i]&0x00ff0000)>>16);
	                              byte3=(unsigned char) ((result2[i]&0x0000ff00)>>8);
	                              byte4=(unsigned char) ((result2[i])&0x000000ff);
#endif
    				      fprintf (desw,"%02x%02x%02x%02x",byte4, byte3, byte2, byte1);
                                      }
				  }
				  else 
				  { 
				  fwrite(total, sizeof(char), strlen(total), desw);
				  fwrite(result2, sizeof(unsigned int),4, desw);
				  }

                                  count++;

				  if ((*digest2==*result2)&&(*(digest2+1)==*(result2+1))&&(*(digest2+2)==*(result2+2))&&(*(digest2+3)==*(result2+3)))
				    {

                               gettimeofday(ft,NULL);
                               elapsed=(ft->tv_sec)-start;
                               elapsed_u=(ft->tv_usec)-start_u;
                               if ((!elapsed_u) && (elapsed))
                                {
		               printf("\n**********************************************\nCollision found ! => %s\n", total);  
                               printf("\n\nCollision found in less than 1 millisecond\nnot enough for statistics report..sorry.\n\n");
                               fflush(stdout);
                               if (!all)
			         return(1);
                                 }
                               else
                                {
                               if (elapsed_u < 0)
	                         {
	                          elapsed_u=1000000+elapsed_u;
                                  if (elapsed>0) elapsed--;
	                         }
                               diff=(float)elapsed+((float)elapsed_u/1000000);
		               printf("\n**********************************************\nCollision found ! => %s\n", total);  
                              printf("\n\nCollision(s) tested : %u in %u second(s), %u millisec, %u microsec.\nAverage of %.1f tests/sec.\n\n", count, elapsed, (elapsed_u/1000), (elapsed_u%1000), ((float)count/diff));
                                      fflush(stdout);
                                      if (!all)
				         return(1);
				    }
                                  }
				}
                              h=(char *)MIN;
			      if (len<2+offset) len=2+offset;
			    }
                           g=(char *)MIN;
			   if (len<3+offset) len=3+offset;
			}
                       f=(char *)MIN;
		       if (len<4+offset) len=4+offset;
		    }
                   e=(char *)MIN;
		   if (len<5+offset) len=5+offset;
		}
              d=(char *)MIN;
	      if (len<6+offset) len=6+offset;
	    }
          c=(char *)MIN;
	  if (len<7+offset) len=7+offset;
	}
      b=(char *)MIN;
      if (len<8+offset) len=8+offset;
    }

  return(0);
}



void hashprint (digest)
unsigned int digest[4];
{
  int i;
  unsigned char byte1, byte2, byte3, byte4;

 for (i=0; i<4; i++)
 {
#ifdef ISBIG_ENDIAN 
         byte1=(unsigned char) ((digest[i])&0x000000ff);
	 byte2=(unsigned char) ((digest[i]&0x0000ff00)>>8);
	 byte3=(unsigned char) ((digest[i]&0x00ff0000)>>16);
	 byte4=(unsigned char) ((digest[i]&0xff000000)>>24);
#else
	 byte1=(unsigned char) ((digest[i])>>24);
	 byte2=(unsigned char) ((digest[i]&0x00ff0000)>>16);
	 byte3=(unsigned char) ((digest[i]&0x0000ff00)>>8);
	 byte4=(unsigned char) ((digest[i])&0x000000ff);
#endif
  printf ("%02x%02x%02x%02x",byte4, byte3, byte2, byte1);

 }
}



