/*
   MDCrack.c
   MD5 collision bruteforcer

   *******************************************
   derived from the RSA Data
   Security, Inc. MD5 Message-Digest Algorithm
   *******************************************

   Try every passwords up to 8 chars length.
   Useful to crack authentication protocols using paswords MD5 hash.
   Use it only to validate a new password choice/something like that 
   and nothing illegal.

   Author: Gregory Duchemin 
   Email : c3rb3r@hotmail.com 
   www : http://mdcrack.multimania.com

   Version 0.1   Date: 21 Feb 2001.
   Version 0.2   Date: 03 Mar 2001.
   Version 0.3   Date: 05 Mar 2001.
   Version 0.4   Date: 07 Mar 2001.
   Version 0.5   Date: 08 Mar 2001.
   Version 0.6   Date: 14 Mar 2001.
   Version 0.7   Date: 18 Mar 2001.
   Version 0.8   Date: 01 Apr 2001.
   Version 0.9   Date: 06 Apr 2001.
*/


#include <stdio.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/timeb.h>
#include <string.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/stat.h>
#include "generic.h"




#ifndef RESUME_FILE
#define RESUME_FILE "/tmp/.mdcrack.resume"
#endif
#ifndef BENCH_HASH
#define BENCH_HASH "ffffffffffffffffffffffffffffffff"
#endif
#ifndef ALFA
#define ALFA "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUWXYZ"
#endif
#ifndef BLOCKSIZE
#define BLOCKSIZE 50
#endif





void hashprint(unsigned int *);

unsigned int count;
unsigned long count2;
unsigned int verbosity=0;
unsigned int benchmode=0;
unsigned int duration=0;
unsigned int custom=0;
unsigned int all=0;
unsigned int ender=0;
unsigned int beginer=0;
unsigned int hwrite=0;
unsigned int hread=0;
unsigned int fastwrite=0;
unsigned int fast=0;
int counter=0;
FILE *desw;
long elapsed;
long elapsed_u;
char target[33];
char *filename;
int crack();
int crack_end();
int crack_verbose();
int crack_rw();
char *alfa;
char *test;
char *total;
extern int optind;
extern char *optarg;
extern void Decode(unsigned int *, unsigned char *, int);
extern void Encode(unsigned char *, unsigned int *, int);
extern int MD5Transform( unsigned int*, unsigned char*, unsigned int);
int md5_reverse(unsigned int *, unsigned int*, unsigned int *);
long start;
long start_u;
char *begin;
char *end;



void handle()
{
 FILE *des;
 struct timeval *ft;
 float diff;
 unsigned int size;
 struct stat *secure;
 int key;

 ft=(struct timeval *) malloc(sizeof(struct timeval));
 if (!ft)
   {
     mderror(7);
     exit(0);
   }
 gettimeofday(ft, NULL);
 elapsed=(ft->tv_sec)-start;
 elapsed_u=(ft->tv_usec)-start_u;


 size=strlen(total);

 if ((hwrite) || (verbosity))
 total[size]=0x00;
 else
 total[size-1]=0x00;

 if (hwrite)
 {
	 printf("\nOutput Hashes file \"%s\" is now closed.\n", filename);
	 fclose(desw);
 }

if (!benchmode)
{
 secure=(struct stat*)malloc(1*sizeof(struct stat));
 if (!secure)
   {
     mderror(7);
     exit(0);
   }
 key=lstat(RESUME_FILE, secure);
 if (S_ISLNK(secure->st_mode))
     printf("\n"RESUME_FILE" is a symlink !..no resume file created, operation too dangerous.\n\n");
  else
  {
 des=fopen(RESUME_FILE, "w+");
 if (des)
  {
	  if ((!hwrite) && (!hread)) strcpy(filename, "none");

   fprintf(des, "%s %s %d %d %s %d %d %s %d %d %d", target, total, verbosity, custom, alfa+1, hwrite, hread, filename, fastwrite, beginer, ender);
   if (!beginer)
	   fprintf(des, " none");
   else
	   fprintf(des, " %s", begin);
   if (!ender)
	   fprintf(des, " none");
   else
	   fprintf(des, " %s", end);

   fclose(des);
  }
 printf("\nGenerating resume file "RESUME_FILE"\n");
  } 
}

 if ((elapsed_u<10000) && (!elapsed))
  {

if (benchmode)
 printf("\nBenchmark result."); 

   printf("\n##########################################\n%s <-- string \n", total);  
   printf("\n\nCollisions tested in less than 10 millisec.\nnot enough for statistics report..sorry.\n\n");
   fflush(stdout);
  }
 else
  {

if (elapsed_u < 0)
	{
	 elapsed_u=1000000+elapsed_u;
         if (elapsed>0) elapsed--;
	}

 diff=(float)elapsed+((float)elapsed_u/1000000);
 

if (benchmode)
 printf("\nBenchmark result."); 

 printf("\n###########################################\n%s <-- string \nCollision(s) tested : %u in %lu second(s), %lu millisec, %lu microsec.\nAverage of %.1f hashes/sec.\n\n", total, count, elapsed, (elapsed_u/1000), (elapsed_u%1000),(float) ((float)count/diff));

 fflush(stdout);
}
 exit (0);
}




void usage(void)
{
 printf("\nMDCrack version 0.9\nT00l to bruteforce password MD5 hashes.\n\nUsage: MDCrack [-h] [-v | -V] [-d] [-W file -R file -F] [-b randomizer] [-e randomizer] [-t secs] [-a] [-s string] [digest] \n-h : (h)elp, this text\n-v : set (v)erbose mode\n-V : more (V)erbose\n-d : (d)elete any resume-file \n-W : file where to (W)rite all computed hashes\n-R : file where to (R)ead computed hashes\n-F : (F)ast write (Hashes file is no longer human-readable)\n-b : string to concatenate (b)efore passwords.\n-e : string to concatenate at passwords (e)nd.\n-t : Benchmark mode (t)imer, compute during secs seconds\n-a : find (a)ll collisions (won't stop to the first found)\n-s : feed a custom charset (s)tring\nNo option at all will force mdcrack to resume a previously stopped session\n\nAuthor: Gregory Duchemin\nEmail: c3rb3r@hotmail.com\nWWW: http://mdcrack.multimania.com \nGreetings to Simeon Pilgrim\n\n*******************************************\nderived from the RSA Data Security Inc.\nMD5 Message-Digest Algorithm\n*******************************************\n\n");
}


int cleanup(reference)
	char *reference;
{

   if (remove(reference))
     return(1); 
return(0);
}








int main (argc, argv)
     int argc;
     char *argv[];
{
  int i;
  int found;
  FILE *des1;
  char c;
  char resume[256];
  char value[33];
  char feed[500];

  bzero(resume, 256);
  bzero(value, 33);
  alfa=(char *)malloc(64);
  strcpy(alfa+1, ALFA);
  *alfa='\0';


 filename=(char *)malloc(512);
 if (!filename)
   {
     mderror(7);
     exit(0);
   }

 if (argc==1) 
  {
   if ((des1=fopen(RESUME_FILE, "r")) == NULL )
    {
     usage();
     mderror(2);
     exit(0); 
    }
   begin=(char *)malloc(256);
   if (!begin)
    {
     mderror(7);
     exit(0);
    }
   end=(char *)malloc(256);
   if (!end)
     {
      mderror(7);
      exit(0);
     }
  fscanf(des1, "%32s %s %d %d %s %d %d %s %d %d %d %s %s", value, resume, &verbosity, &custom, alfa+1, &hwrite, &hread, filename, &fastwrite, &beginer, &ender, begin, end);
  *(alfa)=0x00;
  printf("\n\n"RESUME_FILE" file exists !\nresuming last session..... \n       { \n        Hash: \"%s\"\n        Last try: \"%s\"\n        Verbosity: %d\n        Read: %d\n        Write: %d\n        File: %s\n        Fastmode: %d\n        Charset: %s\n        Begining string: %s\n        Ending string: %s\n       }\n\n", value, resume, verbosity, hread, hwrite, filename, fastwrite, alfa+1, begin, end);
  fflush(stdout); 
  if (hwrite)
   {
    desw=fopen(filename, "a+");
    if (desw==NULL)
    {
     usage();
     mderror(3);
     exit(0); 
    }
   }
 if (hread)
   {
    desw=fopen(filename, "r");
    if (desw==NULL)
    {
     usage();
     mderror(4);
     exit(0); 
    }
   }
 sleep(2);
 }
 else
 {

  while(1)
  {
  c=getopt(argc, argv, "hvVdas:t:b:e:W:R:F");
  if (c==-1)
	 break;

  switch(c)
  {
      case 't':
      benchmode=1;
      duration=atoi(optarg); 
      break;

      case 'h':
      usage(); 
      exit(0);
      break;


      case 'd':
      if (cleanup(RESUME_FILE)) 
      {
      usage();
      mderror(5);
      exit(0);
      }
      else
      {
       printf("\n\nPrevious resume file \""RESUME_FILE"\" deleted.\n\n");
       exit(0);
      }
      break;

      case 'v':
      if (!verbosity)
        verbosity=1;
      break;

      case 'V':
      verbosity=2;
      break;

      case 'b':
      begin=(char *)malloc(strlen(optarg)+1);
      if (!begin)
       {
        mderror(7);
        exit(0);
       }
      strcpy(begin, optarg);
      beginer=1;
      break;

      case 'e':
      end=(char *)malloc(strlen(optarg)+1);
      if (!end)
       {
        mderror(7);
        exit(0);
       }
      strcpy(end, optarg);
      ender=1;
      break;

      case 'a':
      all=1;
      break;

      case 's':
      custom=1;
      realloc(alfa, strlen(optarg)+2);
      strcpy(alfa+1, optarg); 
      *(alfa)='\0';
      break;

      case 'W':
      if (hread)
       {
       usage();
       mderror(9);
       exit(0); 
       }
      if ((desw=fopen(optarg, "w+")) == NULL )
      {
       usage();
       mderror(10);
       exit(0); 
      }
      strcpy(filename, optarg);
      hwrite=1;
      break;


      case 'R':
      if (hwrite)
       {
       usage();
       mderror(9);
       exit(0); 
       }

      if ((desw=fopen(optarg, "r")) == NULL )
      {
       usage();
       mderror(6);
       exit(0); 
      }
      strcpy(filename, optarg);
      hread=1;
      break;


      case 'F':
      fastwrite=1;
      break;

      case '?':
      usage();
      exit(0);
      break;

      default:
      usage();
      break;
   }
  }
 }


if ((optind+1<=argc) || (argc==1) || (benchmode))
 {

   if (argc==1)
      strcpy(feed, value);
   else
   {
    if (benchmode)
    strcpy(feed, BENCH_HASH);
      else
     strcpy(feed, *(argv+optind));
   }

   if (strlen(feed) != 32)
    {
      mderror(1); 
      return(1);
    }


   if (custom) 
   printf("\n\nUsing custom charset : %s \n\n", alfa+1);
   else if (!hread)
   printf("\n\nUsing default charset : %s \n\n",alfa+1);


if (hread)
{    
   if (!(found=crack_read(feed, resume)))
     {
       mderror(0);
      return(1);
     }  
    return(0);
}


   if (verbosity)
    {
     if (!(found=crack_verbose(feed, resume)))
      {
	mderror(0);
      return(1);
      }  
     return (0);
    }

if (hwrite)
{
   if (!(found=crack_rw(feed, resume)))
   {
     mderror(0);
    return(1);
   }  
   return(0);
}


 if (ender)
   {
   if (!(found=crack_end(feed, resume)))
   {
    mderror(0);
    return(1);
   }  
   return(0);
  }
  
 if (!(found=crack(feed, resume)))
   {
    mderror(0);
    return(1);
   }  
    return (0);
 }
 else
 {
  usage();
  exit(0);
 }

}



int ascii2bin(copy, conv, mov)
     char *copy;
     char *conv;
     char *mov;
{
  int i,j,k;
  for (i=0;i<32;i+=2)
    {
      j=0;
      while ((conv[j]!=(*copy)) && (j<16)) j++;
      k=0;
      while ((conv[k]!=(*(copy+1))) && (k<16)) k++;
      *mov= (char) ((j<<4) & 0xf0);
      *mov= (*mov)| (char) (k & 0x0f);
      copy+=2;
      mov++;
    }
  return(1);
}


int up2low(input)
     char *input;
{
  int i;
  for (i=0; i<32; i++)
    if ((*(input+i) >= 65) && (*(input+i) <= 70))
        *(input+i)=*(input+i)+32;
  return(1);
}





int crack(input, resume)
     char *input;
     char *resume;
{
  char conv[]="0123456789abcdef";
  register char *a,*b,*c,*d,*e,*f,*g,*h;
  unsigned int *result2;
  char *copy;
  register unsigned int MAX=(unsigned int) alfa+strlen(alfa+1)+1;
  register unsigned int MIN=(unsigned int) alfa+1; 
  unsigned char i,j; 
  unsigned int offset=0;
  char *mov;
  char digest[16];
  unsigned int digest2[4];
  struct timeval *tp;
  
  unsigned int* x1;
  unsigned int working[4];
  unsigned int size=12;
  register unsigned int len;
  unsigned int tail;

 
 
  tp=(struct timeval *)malloc(sizeof(struct timeval)); 
  if (!tp)
   {
     mderror(7);
     exit(0);
   }
  bzero(digest, 16);
  mov=digest;
  copy=input;
  strncpy(target, input, 32);
  
    a=b=c=d=e=f=g=alfa;

    if (resume[0])
    {
     int bef=0;

     if (beginer) bef=strlen(begin);
     for (i=bef; i<strlen(resume); i++)
       for (j=1;j<=strlen(alfa+1);j++)
         if (resume[i]==alfa[j])
            { 
             if (i==bef)   h=alfa+j;
             if (i==bef+1) g=alfa+j;
             if (i==bef+2) f=alfa+j;
             if (i==bef+3) e=alfa+j;
             if (i==bef+4) d=alfa+j;
             if (i==bef+5) c=alfa+j;
             if (i==bef+6) b=alfa+j;
             if (i==bef+7) a=alfa+j;
            }
    }
  else
    h=(char *)MIN;


  up2low(input);
  ascii2bin(copy, conv, mov);
  Decode(digest2, mov, 16);  
  
  digest2[0] -= 0x67452301;
  digest2[1] -= 0xefcdab89;  
  digest2[2] -= 0x98badcfe;  
  digest2[3] -= 0x10325476;

  if (beginer) offset+=strlen(begin);
  if ((9+offset)>=12) size=(9+offset);
  test=(char *)malloc(size);
  if (!test)
   {
     mderror(7);
     exit(0);
   }
  total=test;
  bzero(test, size);
  if (beginer) 
  {
  strcpy(test, begin);
  test=test+strlen(begin);
  }
  len=1+offset; 
  x1=(unsigned int*)total;


  md5_reverse(working, digest2, x1);			  

  signal(SIGINT, handle);
  if (benchmode)
    {
     alarm(duration);
     signal(SIGALRM, handle);
    }

  gettimeofday(tp, NULL);
  start=tp->tv_sec;
  start_u=tp->tv_usec;


  for(;a<(char *)MAX;a++)
    {
       *(test+7)=*a;
      for(;b<(char *)MAX;b++)
	{
	  *(test+6)=*b;
	  for(;c<(char *)MAX;c++)
	    {
	      *(test+5)=*c;
	      for(;d<(char *)MAX;d++)
		{
		  *(test+4)=*d;
		  for(;e<(char *)MAX;e++)
		    {
		      *(test+3)=*e;
		      for(;f<(char *)MAX;f++)
			{
			  *(test+2)=*f;
			  for(;g<(char *)MAX;g++)
			    {
			      *(test+1)=*g;
			      for(;h<(char *)MAX;h++)
				{
				  *test=*h;
                                  tail=(unsigned int) len << 3;
				  total[len]=0x80;
				  count++;

				  if (MD5Transform(working, total, tail))
				  {
				    if (!stats(total, len))
				      mderror(8);
					
                                    
                                      if (!all)
				         return(1);
				    
                                  }
				}
                              h=(char *)MIN;
			      if (len<2+offset) len=2+offset;
			    }
                           g=(char *)MIN;
			   if (len<3+offset) len=3+offset;
			}
                       f=(char *)MIN;
		       if (len<4+offset) len=4+offset;
		    }
                   e=(char *)MIN;
		   if (len<5+offset) len=5+offset;
		}
              d=(char *)MIN;
	      if (len<6+offset) len=6+offset;
	    }
          c=(char *)MIN;
	  if (len<7+offset) len=7+offset;
	}
      b=(char *)MIN;
      if (len<8+offset) len=8+offset;
    }

  return(0);

}



int crack_verbose(input, resume)
     char *input;
     char *resume;
{
  char conv[]="0123456789abcdef";
  register char *a,*b,*c,*d,*e,*f,*g,*h;
  unsigned int *result2;
  char *copy;
  unsigned int offset=0;
  register int MAX=(unsigned int) alfa+strlen(alfa+1)+1;
  register int MIN=(unsigned int) alfa+1; 
  unsigned char i,j; 
  char *mov;
  char digest[16];
  unsigned int digest2[4];
  struct timeval *tp;
  MD5_CTX context;
  register unsigned int len;
  unsigned int working[4];
  unsigned int size=12;
  unsigned char byte1, byte2, byte3, byte4;


  tp=(struct timeval *)malloc(sizeof(struct timeval)); 
  if (!tp)
   {
     mderror(7);
     exit(0);
   }
  bzero(digest, 16);
  mov=digest;
  copy=input;
  strncpy(target, input, 32);
  
    a=b=c=d=e=f=g=alfa;
    if (resume[0])
    {
     int bef=0, aft=0;

     if (beginer) bef=strlen(begin);
     if (ender) aft=strlen(end);
     for (i=bef; i<strlen(resume)-aft; i++)
       for (j=1;j<=strlen(alfa+1);j++)
         if (resume[i]==alfa[j])
            { 
             if (i==bef)   h=alfa+j;
             if (i==bef+1) g=alfa+j;
             if (i==bef+2) f=alfa+j;
             if (i==bef+3) e=alfa+j;
             if (i==bef+4) d=alfa+j;
             if (i==bef+5) c=alfa+j;
             if (i==bef+6) b=alfa+j;
             if (i==bef+7) a=alfa+j;
            }
    }
  else
    h=(char *)MIN;


  up2low(input);
  ascii2bin(copy, conv, mov);
  Decode(digest2, mov, 16);  
  


  
  if (beginer) offset=strlen(begin);
  if (ender) offset+=strlen(end);
  if ((9+offset)>=12) size=(9+offset);
  test=(char *)malloc(size);
  if (!test)
   {
     mderror(7);
     exit(0);
   }
  total=(char *)malloc(size);
  if (!total)
   {
     mderror(7);
     exit(0);
   }

  bzero(test, size);
  if (beginer) 
    test=test+strlen(begin);

		  


  signal(SIGINT, handle);
  gettimeofday(tp, NULL);
  start=tp->tv_sec;
  start_u=tp->tv_usec;

len=offset+1;
  for(;a<(char *)MAX;a++)
    {
       *(test+7)=*a;
      for(;b<(char *)MAX;b++)
	{
	  *(test+6)=*b;
	  for(;c<(char *)MAX;c++)
	    {
	      *(test+5)=*c;
	      for(;d<(char *)MAX;d++)
		{
		  *(test+4)=*d;
		  for(;e<(char *)MAX;e++)
		    {
		      *(test+3)=*e;
		      for(;f<(char *)MAX;f++)
			{
			  *(test+2)=*f;
			  for(;g<(char *)MAX;g++)
			    {
			      *(test+1)=*g;
			      for(;h<(char *)MAX;h++)
				{
				  *test=*h;
				  *(context.count)=*(context.count+1)=0;
				  *(context.state)=0x67452301;
				  *(context.state+1)=0xefcdab89;
				  *(context.state+2)=0x98badcfe;
				  *(context.state+3)=0x10325476;
				  if (beginer)
				  {
					  strcpy(total, begin); 
					  strcat(total, test);
				  }
				  else
                                  strcpy(total, test);
				  if (ender)
                                    strcat(total, end);

                                  MD5Update (&context, total, len);
                                  result2=(unsigned int*)MD5Final(&context);
				  
				  if (hwrite)
				  if (!fastwrite)
				  {
                                   fprintf(desw, " %s ", total);
                                   for (i=0; i<4; i++)
                                     {
	                              byte1=(unsigned char) ((result2[i])>>24);
	                              byte2=(unsigned char) ((result2[i]&0x00ff0000)>>16);
	                              byte3=(unsigned char) ((result2[i]&0x0000ff00)>>8);
	                              byte4=(unsigned char) ((result2[i])&0x000000ff);
    				      fprintf (desw,"%02x%02x%02x%02x",byte4, byte3, byte2, byte1);
				     }

				  }
				  else 
				  { 
				  fwrite(total, sizeof(char), strlen(total), desw);
				  fwrite(result2, sizeof(unsigned int),4, desw);
				  }

                                  printf("\n%s <-- string.\n",total);
				  if (verbosity==2)
				  {
                                  hashprint(result2);
                                  puts(" <-- hash.");  
                                  hashprint(digest2);
                                  puts(" <-- reference.\n\n");
				  }

                                  fflush(stdout);
                                  count++;
				 
                                  if ((*digest2==*result2)&&(*(digest2+1)==*(result2+1))&&(*(digest2+2)==*(result2+2))&&(*(digest2+3)==*(result2+3)))
				    {
				     if (!stats(total, len))
				       mderror(8);
					
                                     
                                      if (!all)
					return(1);
				    }                                 
				}
                              h=(char *)MIN;
			      if (len<2+offset) len=2+offset;
			    }
                           g=(char *)MIN;
			   if (len<3+offset) len=3+offset;
			}
                       f=(char *)MIN;
		       if (len<4+offset) len=4+offset;
		    }
                   e=(char *)MIN;
		   if (len<5+offset) len=5+offset;
		}
              d=(char *)MIN;
              if (len<6+offset) len=6+offset;
	    }
          c=(char *)MIN;
	  if (len<7+offset) len=7+offset;
	}
      b=(char *)MIN;
      if (len<8+offset) len=8+offset;
    }

  return(0);

}


int crack_end(input, resume)
     char *input;
     char *resume;
{
  char conv[]="0123456789abcdef";
  register char *a,*b,*c,*d,*e,*f,*g,*h;
  unsigned int *result2;
  char *copy;
  register int MAX=(unsigned int) alfa+strlen(alfa+1)+1;
  register int MIN=(unsigned int) alfa+1; 
  unsigned char i,j; 
  unsigned int offset=0;
  char *mov;
  char digest[16];
  unsigned int digest2[4], tail;
  struct timeval *tp;
  register unsigned int len;
  unsigned int* x1;
  unsigned int working[4];
  unsigned int size=12;


  tp=(struct timeval *)malloc(sizeof(struct timeval)); 
  if (!tp)
   {
     mderror(7);
     exit(0);
   }
  bzero(digest, 16);
  mov=digest;
  copy=input;
  strncpy(target, input, 32);
  
    a=b=c=d=e=f=g=alfa;

    if (resume[0])
    {
     int bef=0, aft=0;

     if (beginer) bef=strlen(begin);
     if (ender) aft=strlen(end);
     for (i=bef; i<strlen(resume)-aft; i++)
       for (j=1;j<=strlen(alfa+1);j++)
         if (resume[i]==alfa[j])
            { 
             if (i==bef)   h=alfa+j;
             if (i==bef+1) g=alfa+j;
             if (i==bef+2) f=alfa+j;
             if (i==bef+3) e=alfa+j;
             if (i==bef+4) d=alfa+j;
             if (i==bef+5) c=alfa+j;
             if (i==bef+6) b=alfa+j;
             if (i==bef+7) a=alfa+j;
            }
    }
  else
    h=(char *)MIN;


  up2low(input);
  ascii2bin(copy, conv, mov);
  Decode(digest2, mov, 16);  
  
  digest2[0] -= 0x67452301;
  digest2[1] -= 0xefcdab89;  
  digest2[2] -= 0x98badcfe;  
  digest2[3] -= 0x10325476;

  if (beginer) offset=strlen(begin);
  if (ender) offset+=strlen(end); 
  if ((9+offset)>=12) size=(9+offset);

  test=(char *)malloc(size);
  if (!test)
   {
     mderror(7);
     exit(0);
   }
  total=(char *)malloc(size);
  if (!total)
   {
     mderror(7);
     exit(0);
   }
  bzero(test, size);
  if (beginer) 
   {
  strcpy(test, begin);
  test=test+strlen(begin);
   }
  
  x1=(unsigned int*)total;
  md5_reverse(working, digest2, x1);			  

  signal(SIGINT, handle);
  if (benchmode)
    {
     alarm(duration);
     signal(SIGALRM, handle);
    }
  gettimeofday(tp, NULL);
  start=tp->tv_sec;
  start_u=tp->tv_usec;

len=1+offset;
  for(;a<(char *)MAX;a++)
    {
       *(test+7)=*a;
      for(;b<(char *)MAX;b++)
	{
	  *(test+6)=*b;
	  for(;c<(char *)MAX;c++)
	    {
	      *(test+5)=*c;
	      for(;d<(char *)MAX;d++)
		{
		  *(test+4)=*d;
		  for(;e<(char *)MAX;e++)
		    {
		      *(test+3)=*e;
		      for(;f<(char *)MAX;f++)
			{
			  *(test+2)=*f;
			  for(;g<(char *)MAX;g++)
			    {
			      *(test+1)=*g;
			      for(;h<(char *)MAX;h++)
				{
				  *test=*h;
				if (beginer) 
				{
				strcpy(total, begin); 
				strcat(total, test);
				}
				else
                                  strcpy(total, test);
                                  strcat(total, end);
                                  tail=(unsigned int) len << 3;
				  total[len]=0x80;
				  count++;

				  if (MD5Transform(working, total, tail))
				   {
				    if (!stats(total, len))
				      mderror(8);
				
                              
                                     
                                      if (!all)
				         return(1);
                                  }
				}
                              h=(char *)MIN;
			      if (len<2+offset) len=2+offset;
			    }
                           g=(char *)MIN;
			   if (len<3+offset) len=3+offset;
			}
                       f=(char *)MIN;
		       if (len<4+offset) len=4+offset;
		    }
                   e=(char *)MIN;
		   if (len<5+offset) len=5+offset;
		}
              d=(char *)MIN;
	      if (len<6+offset) len=6+offset;
	    }
          c=(char *)MIN;
          if (len<7+offset) len=7+offset; 
	}
      b=(char *)MIN;
      if (len<8+offset) len=8+offset; 
    }

  return(0);

}




int crack_rw(input, resume)
     char *input;
     char *resume;
{
  char conv[]="0123456789abcdef";
  register char *a,*b,*c,*d,*e,*f,*g,*h;
  unsigned int *result2;
  char *copy, *hash;
  register int MAX=(unsigned int) alfa+strlen(alfa+1)+1;
  register int MIN=(unsigned int) alfa+1; 
  unsigned char i,j; 
  unsigned int offset=0;
  char *mov;
  MD5_CTX context;
  char digest[16];
  unsigned int digest2[4];
  struct timeval *tp;
  char *bufferw;
  register unsigned int len;
  unsigned char byte1, byte2, byte3, byte4;
  unsigned int size=12;

 
  tp=(struct timeval *)malloc(sizeof(struct timeval));
  if (!tp)
   {
     mderror(7);
     exit(0);
   } 
  bzero(digest, 16);
  mov=digest;
  copy=input;
  strncpy(target, input, 32);
  
    a=b=c=d=e=f=g=alfa;

    if (resume[0])
    {
     int bef=0, aft=0;

     if (beginer) bef=strlen(begin);
     if (ender) aft=strlen(end);
     for (i=bef; i<strlen(resume)-aft; i++)
       for (j=1;j<=strlen(alfa+1);j++)
         if (resume[i]==alfa[j])
            { 
             if (i==bef)   h=alfa+j;
             if (i==bef+1) g=alfa+j;
             if (i==bef+2) f=alfa+j;
             if (i==bef+3) e=alfa+j;
             if (i==bef+4) d=alfa+j;
             if (i==bef+5) c=alfa+j;
             if (i==bef+6) b=alfa+j;
             if (i==bef+7) a=alfa+j;
            }
    }
  else
    h=(char *)MIN;


  up2low(input);
  ascii2bin(copy, conv, mov);
  Decode(digest2, mov, 16);  




  if (beginer) offset=strlen(begin);
  if (ender) offset+=strlen(end);

  if ((9+offset)>=12) size=(9+offset);
  test=(char *)malloc(size);
  if (!test)
   {
     mderror(7);
     exit(0);
   }

  hash=(char *)malloc(5);
  if (!hash)
   {
     mderror(7);
     exit(0);
   }
  *(hash+4)='\0';
  if (ender)
    {
     total=(char *)malloc(size);
     if (!total)
     {
      mderror(7);
      exit(0);
     }
    }
  else
  total=test;
  bzero(test, size);
  if (beginer) 
   {
  strcpy(test, begin);
  test=test+strlen(begin);
   }
  

  signal(SIGINT, handle);
  if (benchmode)
    {
     alarm(duration);
     signal(SIGALRM, handle);
    }
  gettimeofday(tp, NULL);
  start=tp->tv_sec;
  start_u=tp->tv_usec;

  len=1+offset;
  for(;a<(char *)MAX;a++)
    {
       *(test+7)=*a;
      for(;b<(char *)MAX;b++)
	{
	  *(test+6)=*b;
	  for(;c<(char *)MAX;c++)
	    {
	      *(test+5)=*c;
	      for(;d<(char *)MAX;d++)
		{
		  *(test+4)=*d;
		  for(;e<(char *)MAX;e++)
		    {
		      *(test+3)=*e;
		      for(;f<(char *)MAX;f++)
			{
			  *(test+2)=*f;
			  for(;g<(char *)MAX;g++)
			    {
			      *(test+1)=*g;
			      for(;h<(char *)MAX;h++)
				{
				  *test=*h;
				  *(context.count)=*(context.count+1)=0;
				  *(context.state)=0x67452301;
				  *(context.state+1)=0xefcdab89;
				  *(context.state+2)=0x98badcfe;
				  *(context.state+3)=0x10325476;
                                  if (ender)
				  {
					  if (beginer)
					  {
						  strcpy(total, begin);
						  strcat(total, test);
					  }
					  else
				                  strcpy(total, test);
                                  strcat(total, end);
				  }
                                  MD5Update (&context, total, len);
                                  result2=(unsigned int*)MD5Final(&context);

				  if (!fastwrite)
				  {
				   fwrite(total, sizeof(char), strlen(total), desw);
                                   fwrite("\0", sizeof(char), 1, desw);
                                   for (i=0; i<4; i++)
                                     {
	                              byte1=(char) ((result2[i])>>24);
	                              byte2=(char) ((result2[i]&0x00ff0000)>>16);
	                              byte3=(char) ((result2[i]&0x0000ff00)>>8);
	                              byte4=(char) ((result2[i])&0x000000ff);
				      *hash=byte4;
                                      *(hash+1)=byte3;
                                      *(hash+2)=byte2;
                                      *(hash+3)=byte1;
                                     
                                      fprintf(desw, "%02x%02x%02x%02x", byte4, byte3, byte2, byte1);
                                     }
                                   fwrite("\0", sizeof(char), 1, desw);  
				  }
				  else 
				  { 
				  fwrite(total, sizeof(char), strlen(total)+1, desw);
				  fwrite(result2, sizeof(unsigned int),4, desw);
				  }

                                  count++;

				  if ((*digest2==*result2)&&(*(digest2+1)==*(result2+1))&&(*(digest2+2)==*(result2+2))&&(*(digest2+3)==*(result2+3)))
				    {
				      if (!stats(total, len))
					mderror(8);
                              
                                     
                                      if (!all)
				         return(1);
				    
                                  }
				}
                              h=(char *)MIN;
			      if (len<2+offset) len=2+offset;
			    }
                           g=(char *)MIN;
			   if (len<3+offset) len=3+offset;
			}
                       f=(char *)MIN;
		       if (len<4+offset) len=4+offset;
		    }
                   e=(char *)MIN;
		   if (len<5+offset) len=5+offset;
		}
              d=(char *)MIN;
	      if (len<6+offset) len=6+offset;
	    }
          c=(char *)MIN;
	  if (len<7+offset) len=7+offset;
	}
      b=(char *)MIN;
      if (len<8+offset) len=8+offset;
    }

  return(0);
}





int crack_read(input, resume)
     char *input;
     char *resume;
{
  char conv[]="0123456789abcdef";
  register char *a,*b,*c,*d,*e,*f,*g,*h;
  unsigned int *result2;
  char *copy;
  char *hash;
  register int MAX=(unsigned int) alfa+strlen(alfa+1)+1;
  register int MIN=(unsigned int) alfa+1; 
  unsigned char i,j; 
  unsigned int offset=0;
  char *mov;
  MD5_CTX context;
  char digest[16];
  unsigned int digest2[4];
  struct timeval *tp;
  float diff;
  char *bufferr, *bufferr2;
  unsigned int amount;
  register unsigned int len;
  unsigned char byte1, byte2, byte3, byte4;
  unsigned int size=12;

  tp=(struct timeval *)malloc(sizeof(struct timeval)); 
  bzero(digest, 16);
  mov=digest;
  copy=input;
  strncpy(target, input, 32);
  
    a=b=c=d=e=f=g=alfa;

    result2=(unsigned int *)malloc(sizeof(unsigned int)*4);
    if (!result2)
     {
      mderror(7);
      exit(0);
     }

    if (resume[0])
    {
     int bef=0, aft=0;

     for (i=bef; i<strlen(resume)-aft; i++)
       for (j=1;j<=strlen(alfa+1);j++)
         if (resume[i]==alfa[j])
            { 
             if (i==bef)   h=alfa+j;
             if (i==bef+1) g=alfa+j;
             if (i==bef+2) f=alfa+j;
             if (i==bef+3) e=alfa+j;
             if (i==bef+4) d=alfa+j;
             if (i==bef+5) c=alfa+j;
             if (i==bef+6) b=alfa+j;
             if (i==bef+7) a=alfa+j;
            }
    }
  else
    h=(char *)MIN;

  up2low(input);
  ascii2bin(copy, conv, mov);
  Decode(digest2, mov, 16);  


  hash=(char *)malloc(17);
  if (!hash)
   {
     mderror(7);
     exit(0);
   }
 
 

  bzero(hash, 17);
 
 
  bufferr=(char *)malloc(BLOCKSIZE*1024*1024);
  if (!bufferr)
    {
      mderror(7);
      exit(0);
    }
 
   signal(SIGINT, handle);
  if (benchmode)
    {
     alarm(duration);
     signal(SIGALRM, handle);
    }



  printf("\n\nFile bufferization in %d Mo sized block(s).\n", BLOCKSIZE);
  printf("\n##########################################\n");
  printf("\nDisk test: read average speed (with %d Mo) ... ", BLOCKSIZE);
  gettimeofday(tp, NULL);
  start=tp->tv_sec;
  start_u=tp->tv_usec;
  amount=fread(bufferr, sizeof(char), BLOCKSIZE*1024*1024, desw);
  gettimeofday(tp, NULL);
  elapsed=tp->tv_sec-start;
  elapsed_u=tp->tv_usec-start_u;

  if (elapsed_u < 0)
    {
     elapsed_u=1000000+elapsed_u;
     if (elapsed>0) elapsed--;
     }
     diff=(float)elapsed+((float) elapsed_u/(float)1000000);
     diff=((float) (amount/(1024*1024)) /diff);
       
     printf(" %.1f Mo/sec.\n", diff);
     fflush(stdout);
     fseek(desw, 0, SEEK_SET);

     gettimeofday(tp, NULL);
     start=tp->tv_sec;
     start_u=tp->tv_usec;
    

    
 
     while((write(1, "\nMounting 1 new memory block ...", 32))&&((amount=fread(bufferr, sizeof(char), BLOCKSIZE*1000000, desw)))&&(puts(" done")))
{
 
  bufferr2=bufferr;
   
  while((unsigned int)bufferr2<(unsigned int) (bufferr+amount))
    {      
      total=bufferr2;
     
      if (!fastwrite)
	{
         test=(unsigned char *)(bufferr2+strlen(total)+1);
         if (verbosity)
	  {
           printf("\n%s <-- Precomputed string", total);
           if (verbosity==2)
	    {
            printf("\n%s <-- Precomputed hash\n", test);
            hashprint(digest2);
            puts(" <-- Reference");
            }
	   fflush(stdout);
          }
         ascii2bin(test, conv, hash);
         Decode(result2, hash, 16);
         bufferr2+=strlen(total)+34;
	}
       else
	 {
           bufferr2+=strlen(total)+1;
	   result2=(unsigned int *)(bufferr2);
           bufferr2+=16;
         }

         count++;
	 if ((*digest2==*result2)&&(*(digest2+1)==*(result2+1))&&(*(digest2+2)==*(result2+2))&&(*(digest2+3)==*(result2+3)))
	       {
		 if (!stats(total, 0))
		   mderror(8);
              
                
                 if (!all)
		   return(1);                        
       }                  
    }
}
puts(" No more byte to read");
return(0);
}





void hashprint (digest)
unsigned int digest[4];
{
  int i;
  unsigned char byte1, byte2, byte3, byte4;

 for (i=0; i<4; i++)
 {
	 byte1=(unsigned char) ((digest[i])>>24);
	 byte2=(unsigned char) ((digest[i]&0x00ff0000)>>16);
	 byte3=(unsigned char) ((digest[i]&0x0000ff00)>>8);
	 byte4=(unsigned char) ((digest[i])&0x000000ff);
  
	 printf ("%02x%02x%02x%02x",byte4, byte3, byte2, byte1);

 }
}



