#include <stdio.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/timeb.h>
#include <string.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/stat.h>
#include "generic.h"


extern unsigned int all;
extern long elapsed_u, elapsed;
extern long start_u, start;
extern unsigned int count;


int stats(char *total, unsigned int len )
{
 struct timeval *ft;
 float diff;
 ft=(struct timeval *)malloc(sizeof(struct timeval));
 if (!ft)
   {
     mderror(7);
     exit(0);
   }



 gettimeofday(ft, NULL);
 elapsed=(ft->tv_sec)-start;
 elapsed_u=(ft->tv_usec)-start_u;
                               
 if (len)			        
 total[len]=0x00;
 if ((elapsed_u<10000) && (!elapsed))
   {
     printf("\n##########################################\nCollision found ! => %s\n", total);  
     printf("\n\nCollision found in less than 10 millisec.\nnot enough for statistics report..sorry.\n\n");
    } 
 else
    {
     if (elapsed_u < 0)
      {
       elapsed_u=1000000+elapsed_u;
       if (elapsed>0) elapsed--;
      }
     diff=(float)elapsed+((float)elapsed_u/1000000 );
     printf("\n##########################################\nCollision found ! => %s\n", total);  
     printf("\n\nCollision(s) tested : %u in %u second(s), %u millisec, %u microsec.\nAverage of %.1f hashes/sec.\n\n", count, elapsed, (elapsed_u/1000), (elapsed_u%1000), ((float)count/diff));
    }
 return(1);
}
