
/*

   md5c.c 
   MD5 generation core.
   based on RSA Data Security, Inc., MD5 message-digest algorithm

 */



/* 
Copyright (C) 1991-2, RSA Data Security, Inc. Created 1991. All
rights reserved.

License to copy and use this software is granted provided that it
is identified as the "RSA Data Security, Inc. MD5 Message-Digest
Algorithm" in all material mentioning or referencing this software
or this function.

License is also granted to make and use derivative works provided
that such works are identified as "derived from the RSA Data
Security, Inc. MD5 Message-Digest Algorithm" in all material
mentioning or referencing the derived work.

RSA Data Security, Inc. makes no representations concerning either
the merchantability of this software or the suitability of this
software for any particular purpose. It is provided "as is"
without express or implied warranty of any kind.

These notices must be retained in any copies of any part of this
documentation and/or software.
 */



#include <stdio.h>
#include "./generic.h"






void Encode (output, input, len)
unsigned char *output;
unsigned int *input;
unsigned int len;
{
  register i, j;

  for (i = 0, j = 0; j < len; i++, j += 4) {
 output[j] = (unsigned char)(input[i] & 0xff);
 output[j+1] = (unsigned char)((input[i] >> 8) & 0xff);
 output[j+2] = (unsigned char)((input[i] >> 16) & 0xff);
 output[j+3] = (unsigned char)((input[i] >> 24) & 0xff);
  }
}





void Decode (output, input, len)
unsigned int *output;
unsigned char *input;
unsigned int len;
{
  register i, j;

  for (i = 0, j = 0; j < len; i++, j += 4)
 output[i] = ((unsigned int)input[j]) | (((unsigned int)input[j+1]) << 8) |
   (((unsigned int)input[j+2]) << 16) | (((unsigned int)input[j+3]) << 24);
}














