

/*

stats.c

statistics output system

*/






#include <stdio.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/timeb.h>
#include <string.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/stat.h>
#include "generic.h"
#ifdef NCURSES
#include <ncurses.h>
#endif

extern unsigned int all, val;
extern long elapsed_u, elapsed;
extern long start_u, start;
extern unsigned long count;
extern unsigned char *test;

#ifndef NCURSES
#define printw printf
#endif


int stats(char *total, unsigned int len )
{
  struct timeval ft;
  float diff;
  unsigned int i;
  

  
  gettimeofday(&ft, NULL);
  elapsed=(ft.tv_sec)-start;
  elapsed_u=(ft.tv_usec)-start_u;


 signal(SIGINT, SIG_DFL);
 alarm(0);

#ifdef NCURSES
  attrset(COLOR_PAIR(2));
#endif
  
  if (val==2) test[0]++;


  if (total[len]==(char)0x80)			        
    total[len]=0x00;
  
  if ((elapsed_u<10000) && (!elapsed))
    {
      printw("\n\n");
      for (i=0; i<40; i++)
	{

#ifdef NCURSES 
	  if (((i<14)||(i>25))&&(i!=11)&&(i!=28))
	    attrset(COLOR_PAIR(1));
	  else
	    attrset(COLOR_PAIR(1)|A_BOLD);
#endif
	  printw(SYMBOL);
	}
      printw("\n");
      
      printw("Collision found ! => ");  
      
#ifdef NCURSES
      refresh();
      attrset(COLOR_PAIR(2)|A_BOLD);
#endif

      printw("%s\n", total);
      mdmesg(12, NULL);
    } 
  else
    {
      if (elapsed_u < 0)
	{
	  elapsed_u=1000000+elapsed_u;
	  if (elapsed>0) elapsed--;
	}

#ifdef NCURSES
      attrset(COLOR_PAIR(2));
#endif
      diff=(float)elapsed+((float)elapsed_u/1000000 );
      
      printw("\n\n");
      for (i=0; i<40; i++)
	{
	  
#ifdef NCURSES 
	  if (((i<14)||(i>25))&&(i!=11)&&(i!=28))
	    attrset(COLOR_PAIR(1));
	  else
	    attrset(COLOR_PAIR(1)|A_BOLD);
#endif

	  printw(SYMBOL);
	}
      printw("\n");
      printw("Collision found ! => ");  
      
      
#ifdef NCURSES
      refresh();
      attrset(COLOR_PAIR(2)|A_BOLD);
#endif
      
      printw("%s\n", total);
      
#ifdef NCURSES
      refresh();
      attrset(COLOR_PAIR(2));
#endif
      
      printw("\n\nCollision(s) tested : %lu in %u second(s), %u millisec, %u microsec.\nAverage of %.1f hashes/sec.\n\n", count, elapsed, (elapsed_u/1000), (elapsed_u%1000), (float)((long)count/diff));
      
    }
  
#ifdef NCURSES
  refresh();
#else
  fflush(stdout);
#endif
  
  return(1);
}





















